/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.ingest.server.service.IngestService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ingest"})
@RequestMapping(value={"/v1/ingest"})
@RestController
@ResponseBody
public class IngestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestController.class);
    private final IngestService ingestService;

    @Autowired
    public IngestController(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Secured(value={"ROLE_GET_ALL_INGEST"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws PreconditionFailedException, IOException {
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        SanityChecker.sanitizeCriteria(criteria);
        if (criteria.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)VitamUIUtils.convertObjectFromJson((String)criteria.get(), Object.class));
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.ingestService.getAllPaginated(page, size, orderBy, direction, criteria);
    }

    @Secured(value={"ROLE_GET_INGEST"})
    @GetMapping(value={"/{id}"})
    public LogbookOperationDto getOne(@PathVariable(value="id") String id) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get One Ingest id={}", (Object)id);
        return this.ingestService.getOne(id);
    }

    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/odtreport/{id}"})
    public byte[] generateODTReport(@PathVariable(value="id") String id) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter :", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("export ODT report for ingest with id :{}", (Object)id);
        return this.ingestService.generateODTReport(id);
    }

    @Secured(value={"ROLE_CREATE_INGEST"})
    @ApiOperation(value="Upload an streaming SIP", consumes="application/octet-stream")
    @PostMapping(value={"/upload"}, consumes={"application/octet-stream"})
    public ResponseEntity<Void> streamingUpload(InputStream inputStream, @RequestHeader(value="X-Action") String action, @RequestHeader(value="X-Context-Id") String contextId) throws PreconditionFailedException, IngestExternalException {
        ParameterChecker.checkParameter((String)"The action and the context ID are mandatory parameters: ", (String[])new String[]{action, contextId});
        LOGGER.debug("[Ingest] upload file ");
        return this.ingestService.streamingUpload(inputStream, contextId, action);
    }
}

