/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamIngestConfig;
import fr.gouv.vitamui.iam.client.CustomerRestClient;
import fr.gouv.vitamui.iam.client.ExternalParametersRestClient;
import fr.gouv.vitamui.iam.client.IamRestClientFactory;
import fr.gouv.vitamui.iam.client.UserRestClient;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.ingest.server.config.ApiIngestApplicationProperties;
import fr.gouv.vitamui.ingest.server.security.WebSecurityConfig;
import fr.gouv.vitamui.ingest.server.service.IngestAccessContractService;
import fr.gouv.vitamui.ingest.server.service.IngestExternalParametersService;
import fr.gouv.vitamui.ingest.server.service.IngestGeneratorODTFile;
import fr.gouv.vitamui.ingest.server.service.IngestService;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@Import(value={RestExceptionHandler.class, SwaggerConfiguration.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamIngestConfig.class, VitamAdministrationConfig.class, HttpMessageConvertersAutoConfiguration.class})
public class ApiIngestServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SecurityRestClientFactory securityRestClientFactory(ApiIngestApplicationProperties apiIngestApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityRestClientFactory(apiIngestApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextCrudRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public MappingJackson2HttpMessageConverter customizedJacksonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.APPLICATION_OCTET_STREAM));
        return converter;
    }

    @Bean
    public UserAuthenticationService authentificationService(UserRestClient userRestClient) {
        return new IamClientUserAuthenticationService(userRestClient);
    }

    @Bean
    public InternalApiAuthenticationProvider internalApiAuthenticationProvider(UserAuthenticationService userAuthenticationService) {
        return new InternalApiAuthenticationProvider(userAuthenticationService);
    }

    @Bean
    public ExternalApiAuthenticationProvider externalApiAuthenticationProvider(SecurityRestClientFactory securityRestClientFactory, UserAuthenticationService userAuthenticationService) {
        return new ExternalApiAuthenticationProvider(securityRestClientFactory.getContextRestClient(), userAuthenticationService);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(InternalApiAuthenticationProvider internalApiAuthenticationProvider, ExternalApiAuthenticationProvider externalApiAuthenticationProvider) {
        return new ApiAuthenticationProvider(internalApiAuthenticationProvider, externalApiAuthenticationProvider);
    }

    @Bean
    public SecurityService externalSecurityService() {
        return new SecurityService();
    }

    @Bean
    public IamRestClientFactory iamExternalRestClientFactory(ApiIngestApplicationProperties apiIngestApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamRestClientFactory(apiIngestApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public UserRestClient userInternalRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getUserExternalRestClient();
    }

    @Bean
    public CustomerRestClient customerExternalRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getCustomerExternalRestClient();
    }

    @Bean
    public IngestGeneratorODTFile ingestGeneratorODTFile() {
        return new IngestGeneratorODTFile();
    }

    @Bean
    public ExternalParametersRestClient externalParametersExternalRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getExternalParametersExternalRestClient();
    }

    @Bean
    public IngestService ingestInternalService(SecurityService securityService, LogbookService logbookService, ObjectMapper objectMapper, IngestExternalClient ingestExternalClient, CustomerRestClient customerRestClient, IngestGeneratorODTFile ingestGeneratorODTFile, IngestExternalParametersService ingestExternalParametersService, IngestAccessContractService ingestAccessContractService, UserRestClient userRestClient) {
        return new IngestService(securityService, logbookService, objectMapper, ingestExternalClient, customerRestClient, userRestClient, ingestGeneratorODTFile, ingestExternalParametersService, ingestAccessContractService);
    }
}

