/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.utils;

import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.ContextStatus;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.common.dto.PermissionDto;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileDto;
import java.util.HashSet;
import java.util.Set;

public class ReferentialDtoBuilder {
    public static ContextDto buildContextDto(String id) {
        ContextDto contextDto = new ContextDto();
        contextDto.setId(id);
        contextDto.setIdentifier("identifier");
        contextDto.setName("name");
        contextDto.setStatus(ContextStatus.ACTIVE.toString());
        contextDto.setEnableControl(Boolean.valueOf(true));
        contextDto.setSecurityProfile("securityProfile");
        return contextDto;
    }

    public static RuleDto buildRuleDto(String id, String ruleId, String ruleType, String ruleValue, String ruleDescription, String ruleDuration, String ruleMeasurement) {
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId(id);
        ruleDto.setRuleId(ruleId);
        ruleDto.setRuleType(ruleType);
        ruleDto.setRuleValue(ruleValue);
        ruleDto.setRuleDescription(ruleDescription);
        ruleDto.setRuleDuration(ruleDuration);
        ruleDto.setRuleMeasurement(ruleMeasurement);
        return ruleDto;
    }

    public static AccessContractDto buildAccessContractDto(String id) {
        AccessContractDto accessContractDto = new AccessContractDto();
        accessContractDto.setId(id);
        accessContractDto.setIdentifier("identifier");
        accessContractDto.setName("name");
        accessContractDto.setStatus(ActivationStatus.ACTIVE);
        return accessContractDto;
    }

    public static IngestContractDto buildIngestContractDto(String id) {
        IngestContractDto ingestContractDto = new IngestContractDto();
        ingestContractDto.setId(id);
        ingestContractDto.setIdentifier("identifier");
        ingestContractDto.setName("name");
        ingestContractDto.setStatus(ActivationStatus.ACTIVE);
        return ingestContractDto;
    }

    public static SecurityProfileDto buildSecurityProfileDto(String id) {
        SecurityProfileDto securityProfileDto = new SecurityProfileDto();
        securityProfileDto.setId(id);
        securityProfileDto.setIdentifier("identifier");
        securityProfileDto.setName("name");
        return securityProfileDto;
    }

    public static Set<PermissionDto> buildPermissions() {
        HashSet<String> contracts = new HashSet<String>();
        contracts.add("contract");
        PermissionDto permission1 = new PermissionDto();
        permission1.setTenant("tenant_1");
        permission1.setAccessContracts(contracts);
        permission1.setIngestContracts(contracts);
        PermissionDto permission2 = new PermissionDto();
        permission2.setTenant("tenant_2");
        permission2.setAccessContracts(contracts);
        permission2.setIngestContracts(contracts);
        HashSet<PermissionDto> permissions = new HashSet<PermissionDto>();
        permissions.add(permission1);
        permissions.add(permission2);
        return permissions;
    }

    public static ContextDto getContextDto() {
        ContextDto ctxt = new ContextDto();
        ctxt.setEnableControl(Boolean.valueOf(false));
        ctxt.setName("Contexte Name");
        ctxt.setActivationDate("05-07-2021");
        ctxt.setSecurityProfile("vitam-security-profile");
        HashSet<PermissionDto> permissionsDto = new HashSet<PermissionDto>();
        PermissionDto permissionDto = new PermissionDto();
        permissionDto.setTenant("1");
        permissionDto.setAccessContracts(new HashSet());
        permissionDto.setIngestContracts(new HashSet());
        permissionsDto.add(permissionDto);
        ctxt.setPermissions(permissionsDto);
        return ctxt;
    }
}

