/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.utils;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitamui.referential.common.dto.AgencyCSVDto;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.common.utils.AgencyConverter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

class AgencyConverterTest {
    final ObjectMapper objectMapper = new ObjectMapper();

    AgencyConverterTest() {
    }

    @Test
    void convertDtoToVitam() {
        AgencyDto agencyDto = this.agencyDto();
        AgenciesModel agencyModel = AgencyConverter.convertDtoToVitam((AgencyDto)agencyDto);
        AgenciesModel agencyModelExpected = this.agencyModel();
        Assertions.assertEquals((Object)agencyModelExpected, (Object)agencyModel);
    }

    @Test
    void convertVitamToDto() {
        AgenciesModel agencyModel = this.agencyModel();
        AgencyDto agencyDto = AgencyConverter.convertVitamToDto((AgenciesModel)agencyModel);
        AgencyDto agencyDtoExpected = this.agencyDto();
        Assertions.assertEquals((Object)agencyDtoExpected, (Object)agencyDto);
    }

    @Test
    void convertDtosToVitams() {
        List<AgencyDto> agencyDtos = List.of(this.agencyDto());
        List agenciesModels = AgencyConverter.convertDtosToVitams(agencyDtos);
        List<AgenciesModel> agenciesModelsExpected = List.of(this.agencyModel());
        Assertions.assertEquals(agenciesModelsExpected, (Object)agenciesModels);
    }

    @Test
    void convertVitamsToDtos() {
        List<AgenciesModel> agenciesModels = List.of(this.agencyModel());
        List agencyDtos = AgencyConverter.convertVitamsToDtos(agenciesModels);
        List<AgencyDto> agencyDtosExpected = List.of(this.agencyDto());
        Assertions.assertEquals(agencyDtosExpected, (Object)agencyDtos);
    }

    @Test
    void convertDtoToCsvDto() {
        AgenciesModel agencyModel = this.agencyModel();
        AgencyCSVDto agencyCSVDto = AgencyConverter.convertDtoToCsvDto((AgenciesModel)agencyModel);
        AgencyCSVDto agencyCSVDtoExpected = this.agencyCSVDto();
        Assertions.assertEquals((Object)agencyCSVDtoExpected, (Object)agencyCSVDto);
    }

    @Test
    void convertDtosToCsvDtos() {
        List<AgenciesModel> agenciesModels = List.of(this.agencyModel());
        List agencyCSVDtos = AgencyConverter.convertDtosToCsvDtos(agenciesModels);
        List<AgencyCSVDto> agencyCSVDtosExpected = List.of(this.agencyCSVDto());
        Assertions.assertEquals(agencyCSVDtosExpected, (Object)agencyCSVDtos);
    }

    @Test
    void toJSONAgencyDto() throws Exception {
        List<AgencyDto> agencyDtos = List.of(this.agencyDto());
        String json = this.objectMapper.writeValueAsString(agencyDtos);
        String expectedJson = PropertiesUtils.getResourceAsString((String)"agency/agenciesDto.json");
        System.out.println(json);
        JSONAssert.assertEquals((String)expectedJson, (String)json, (boolean)true);
    }

    @Test
    void toJSONAgenciesModel() throws Exception {
        List<AgenciesModel> agenciesModels = List.of(this.agencyModel());
        String json = this.objectMapper.writeValueAsString(agenciesModels);
        String expectedJson = PropertiesUtils.getResourceAsString((String)"agency/agenciesModels.json");
        System.out.println(json);
        JSONAssert.assertEquals((String)expectedJson, (String)json, (boolean)true);
    }

    @Test
    void toCSVAgencyCSVDto() throws Exception {
        CsvMapper csvMapper = new CsvMapper();
        CsvSchema schema = csvMapper.schemaFor(AgencyCSVDto.class).withColumnSeparator(',').withHeader();
        ObjectWriter writer = csvMapper.writer((FormatSchema)schema);
        StringWriter stringWriter = new StringWriter();
        writer.writeValue((Writer)stringWriter, (Object)this.agencyCSVDto());
        String expectedCSV = PropertiesUtils.getResourceAsString((String)"agency/AgencyCSVDto.csv");
        Assertions.assertEquals((Object)expectedCSV, (Object)stringWriter.toString());
    }

    private AgencyDto agencyDto() {
        AgencyDto agencyDto = new AgencyDto();
        agencyDto.setId("agency_id");
        agencyDto.setTenant(Integer.valueOf(4));
        agencyDto.setVersion(Integer.valueOf(12));
        agencyDto.setName("agency_id");
        agencyDto.setIdentifier("agency_identifier");
        agencyDto.setDescription("agency_description");
        agencyDto.setEntityType("agency_entityType");
        agencyDto.setNameEntryParallel(List.of("agency_nameEntryParallel"));
        agencyDto.setAuthorizedForm(List.of("agency_authorizedForm"));
        agencyDto.setAlternativeForm(List.of("agency_alternativeForm"));
        agencyDto.setEntityId("agency_entityId");
        agencyDto.setFromDate("agency_fromDate");
        agencyDto.setToDate("agency_toDate");
        agencyDto.setFunctions(List.of("agency_functions"));
        agencyDto.setBiogHist("agency_biogHist");
        agencyDto.setPlaces(List.of("agency_places"));
        agencyDto.setLegalStatuses(List.of("agency_legalStatuses"));
        agencyDto.setMandates(List.of("agency_mandates"));
        agencyDto.setStructureOrGenealogy("agency_structureOrGenealogy");
        agencyDto.setGeneralContext("agency_generalContext");
        agencyDto.setCreationDate("agency_creationDate");
        agencyDto.setUpdateDate("agency_updateDate");
        agencyDto.setMaintenanceStatus("agency_maintenanceStatus");
        agencyDto.setLocalStatus("agency_localStatus");
        agencyDto.setSources(List.of("agency_sources"));
        agencyDto.setEventDescription("agency_eventDescription");
        return agencyDto;
    }

    private AgenciesModel agencyModel() {
        AgenciesModel agencyModel = new AgenciesModel();
        agencyModel.setId("agency_id");
        agencyModel.setTenant(Integer.valueOf(4));
        agencyModel.setVersion(Integer.valueOf(12));
        agencyModel.setName("agency_id");
        agencyModel.setIdentifier("agency_identifier");
        agencyModel.setDescription("agency_description");
        agencyModel.setEntityType("agency_entityType");
        agencyModel.setNameEntryParallel(List.of("agency_nameEntryParallel"));
        agencyModel.setAuthorizedForm(List.of("agency_authorizedForm"));
        agencyModel.setAlternativeForm(List.of("agency_alternativeForm"));
        agencyModel.setEntityId("agency_entityId");
        agencyModel.setFromDate("agency_fromDate");
        agencyModel.setToDate("agency_toDate");
        agencyModel.setFunctions(List.of("agency_functions"));
        agencyModel.setBiogHist("agency_biogHist");
        agencyModel.setPlaces(List.of("agency_places"));
        agencyModel.setLegalStatuses(List.of("agency_legalStatuses"));
        agencyModel.setMandates(List.of("agency_mandates"));
        agencyModel.setStructureOrGenealogy("agency_structureOrGenealogy");
        agencyModel.setGeneralContext("agency_generalContext");
        agencyModel.setCreationDate("agency_creationDate");
        agencyModel.setUpdateDate("agency_updateDate");
        agencyModel.setMaintenanceStatus("agency_maintenanceStatus");
        agencyModel.setLocalStatus("agency_localStatus");
        agencyModel.setSources(List.of("agency_sources"));
        agencyModel.setEventDescription("agency_eventDescription");
        return agencyModel;
    }

    private AgencyCSVDto agencyCSVDto() {
        AgencyCSVDto agencyCSVDto = new AgencyCSVDto();
        agencyCSVDto.setName("agency_id");
        agencyCSVDto.setIdentifier("agency_identifier");
        agencyCSVDto.setDescription("agency_description");
        agencyCSVDto.setEntityType("agency_entityType");
        agencyCSVDto.setNameEntryParallel(List.of("agency_nameEntryParallel"));
        agencyCSVDto.setAuthorizedForm(List.of("agency_authorizedForm"));
        agencyCSVDto.setAlternativeForm(List.of("agency_alternativeForm"));
        agencyCSVDto.setEntityId("agency_entityId");
        agencyCSVDto.setFromDate("agency_fromDate");
        agencyCSVDto.setToDate("agency_toDate");
        agencyCSVDto.setFunctions(List.of("agency_functions"));
        agencyCSVDto.setBiogHist("agency_biogHist");
        agencyCSVDto.setPlaces(List.of("agency_places"));
        agencyCSVDto.setLegalStatuses(List.of("agency_legalStatuses"));
        agencyCSVDto.setMandates(List.of("agency_mandates"));
        agencyCSVDto.setStructureOrGenealogy("agency_structureOrGenealogy");
        agencyCSVDto.setGeneralContext("agency_generalContext");
        agencyCSVDto.setMaintenanceStatus("agency_maintenanceStatus");
        agencyCSVDto.setLocalStatus("agency_localStatus");
        agencyCSVDto.setSources(List.of("agency_sources"));
        agencyCSVDto.setEventDescription("agency_eventDescription");
        return agencyCSVDto;
    }
}

