/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.referential.common.service.VitamFileFormatCommonService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class VitamFileFormatCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @Mock
    private AccessExternalClient accessExternalClient;
    private VitamFileFormatCommonService vitamFileFormatCommonService;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks(VitamFileFormatCommonServiceTest.class);
        ObjectMapper objectMapper = new ObjectMapper();
        this.vitamFileFormatCommonService = new VitamFileFormatCommonService(this.adminExternalClient, objectMapper, this.accessExternalClient);
    }

    @Test
    public void findFileFormats_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)select)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.lambda$findFileFormats_should_return_ok_when_vitamclient_ok$0(vitamContext, (JsonNode)select)).doesNotThrowAnyException();
    }

    @Test
    public void findFileFormats_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)select)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.lambda$findFileFormats_should_throw_BadRequestException_when_vitamclient_400$1(vitamContext, (JsonNode)select)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findFileFormats_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        Mockito.when((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)select)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.lambda$findFileFormats_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(vitamContext, (JsonNode)select)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findFileFormatById_should_return_ok_when_vitamclient_ok() throws VitamClientException, InvalidCreateOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "Id_0";
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)id));
        ObjectNode selectQuery = select.getFinalSelect();
        Mockito.when((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)selectQuery)).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamFileFormatCommonService.findFileFormatById(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void findFileFormatById_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException, InvalidCreateOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "Id_0";
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)id));
        ObjectNode selectQuery = select.getFinalSelect();
        Mockito.when((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)selectQuery)).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamFileFormatCommonService.findFileFormatById(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findFileFormatById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException, InvalidCreateOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "Id_0";
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)id));
        ObjectNode selectQuery = select.getFinalSelect();
        Mockito.when((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)selectQuery)).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by Vitam")});
        Assertions.assertThatCode(() -> this.vitamFileFormatCommonService.findFileFormatById(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    private /* synthetic */ void lambda$findFileFormats_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamFileFormatCommonService.findFileFormats(vitamContext, select);
    }

    private /* synthetic */ void lambda$findFileFormats_should_throw_BadRequestException_when_vitamclient_400$1(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamFileFormatCommonService.findFileFormats(vitamContext, select);
    }

    private /* synthetic */ void lambda$findFileFormats_should_return_ok_when_vitamclient_ok$0(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamFileFormatCommonService.findFileFormats(vitamContext, select);
    }
}

