/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.referential.common.service.VitamAgencyCommonService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class VitamAgencyCommonServiceTest {
    @Mock
    private AdminExternalClient adminExternalClient;
    @Mock
    private AccessExternalClient accessExternalClient;
    @Mock
    private AgencyCommonService agencyCommonService;
    @InjectMocks
    private VitamAgencyCommonService vitamAgencyCommonService;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.vitamAgencyCommonService = new VitamAgencyCommonService(this.adminExternalClient, this.agencyCommonService, objectMapper, this.accessExternalClient);
    }

    @Test
    public void export_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        Mockito.when((Object)this.accessExternalClient.selectOperations((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().addResult((Object)logbookOperation).setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.downloadAgenciesCsvAsStream((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)Response.status((int)200).build());
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.export(vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        Mockito.when((Object)this.accessExternalClient.selectOperations((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Mockito.when((Object)this.adminExternalClient.downloadAgenciesCsvAsStream((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)Response.status((int)400).build());
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_throw_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        Mockito.when((Object)this.accessExternalClient.selectOperations((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Mockito.when((Object)this.adminExternalClient.downloadAgenciesCsvAsStream((VitamContext)ArgumentMatchers.any(VitamContext.class), (String)ArgumentMatchers.any(String.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void patchAgency_should_return_ok_when_vitamclient_ok() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        AgenciesModel patchAgency = new AgenciesModel();
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.patchAgency(vitamContext, id, patchAgency)).doesNotThrowAnyException();
    }

    @Test
    public void patchAgency_should_return_400_when_vitamclient_400() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        AgenciesModel patchAgency = new AgenciesModel();
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.deleteAgency(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void patchAgency_should_throw_VitamClientException_when_vitamclient_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        AgenciesModel patchAgency = new AgenciesModel();
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.patchAgency(vitamContext, id, patchAgency)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void patchAgency_should_return_ok_with_additional_properties() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgenciesModel patchAgency = new AgenciesModel();
        patchAgency.setId("agency_01");
        patchAgency.setName("AlexAgency");
        patchAgency.setDescription("AlexAgency super description");
        patchAgency.setPlaces(List.of("Place 1", "Place 2"));
        patchAgency.setLocalStatus("Local status");
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200).addResult((Object)new AgenciesModel().setId(patchAgency.getId()).setName(patchAgency.getName())));
        StringBuilder actualCsvContent = new StringBuilder();
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenAnswer(invocation -> {
            InputStream is = (InputStream)invocation.getArgument(1);
            actualCsvContent.append(CharStreams.toString((Readable)new InputStreamReader(is, StandardCharsets.UTF_8)));
            return new RequestResponseOK().setHttpCode(200);
        });
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.patchAgency(vitamContext, patchAgency.getId(), patchAgency)).doesNotThrowAnyException();
        ((AdminExternalClient)Mockito.verify((Object)this.adminExternalClient)).createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.eq((Object)"Agencies.json"));
        String expectedCsvContent = PropertiesUtils.getResourceAsString((String)"agency/agency_with_additional_properties.csv");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCsvContent, (Object)actualCsvContent.toString());
    }

    @Test
    public void patchAgency_should_return_ok_with_additionnal_properties_and_existing() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgenciesModel patchAgency = new AgenciesModel();
        patchAgency.setId("agency_01");
        patchAgency.setName("AlexAgency");
        patchAgency.setDescription("AlexAgency super description");
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200).addAllResults(List.of(new AgenciesModel().setId(patchAgency.getId()).setName(patchAgency.getName()).setEntityType("entity_type_to_remove").setCreationDate("2024-12-25T12:34:56.123").setUpdateDate("2024-12-25T12:34:56.123").setTenant(Integer.valueOf(4)), new AgenciesModel().setId("agency_15").setName("agency_15").setEntityType("entity_type_to_keep").setCreationDate("2024-12-25T12:34:56.123").setUpdateDate("2024-12-25T12:34:56.123").setTenant(Integer.valueOf(4)))));
        StringBuilder actualCsvContent = new StringBuilder();
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenAnswer(invocation -> {
            InputStream is = (InputStream)invocation.getArgument(1);
            actualCsvContent.append(CharStreams.toString((Readable)new InputStreamReader(is, StandardCharsets.UTF_8)));
            return new RequestResponseOK().setHttpCode(200);
        });
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.patchAgency(vitamContext, patchAgency.getId(), patchAgency)).doesNotThrowAnyException();
        ((AdminExternalClient)Mockito.verify((Object)this.adminExternalClient)).createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.eq((Object)"Agencies.json"));
        String expectedCsvContent = PropertiesUtils.getResourceAsString((String)"agency/agency_with_additional_properties_and_others.csv");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedCsvContent, (Object)actualCsvContent.toString());
    }

    @Test
    public void deleteAgency_should_return_ok_when_vitamclient_ok() throws VitamClientException, AccessExternalClientException, IOException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.deleteAgency(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteAgency_should_return_400_when_vitamclient_400() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.deleteAgency(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void deleteAgency_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception throw by vitam")});
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.deleteAgency(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void create_should_return_ok_when_vitamclient_ok() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgenciesModel newAgency = new AgenciesModel();
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.create(vitamContext, newAgency)).doesNotThrowAnyException();
    }

    @Test
    public void create_should_return_ok_when_vitamclient_400() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgenciesModel newAgency = new AgenciesModel();
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(400));
        Mockito.when((Object)this.adminExternalClient.createAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (InputStream)ArgumentMatchers.any(InputStream.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new RequestResponseOK().setHttpCode(200));
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.create(vitamContext, newAgency)).doesNotThrowAnyException();
    }

    @Test
    public void create_should_throw_VitamClientException_when_vitamclient_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgenciesModel newAgency = new AgenciesModel();
        Mockito.when((Object)this.agencyCommonService.findAgencies((VitamContext)ArgumentMatchers.any(VitamContext.class), (JsonNode)ArgumentMatchers.any(JsonNode.class))).thenThrow(new Throwable[]{new VitamClientException("Exception thrown by vitam")});
        Assertions.assertThatCode(() -> this.vitamAgencyCommonService.create(vitamContext, newAgency)).isInstanceOf(VitamClientException.class);
    }
}

