/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.administration.schema.SchemaCardinality;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitamui.referential.common.service.ImportSchemaCommonService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;

@ExtendWith(value={MockitoExtension.class})
class ImportSchemaCommonServiceTest {
    @Mock
    private Logger logger;
    private VitamContext vitamContext;
    private AdminExternalClient adminExternalClient;
    private ImportSchemaCommonService importSchemaCommonService;
    private ObjectMapper objectMapper;

    ImportSchemaCommonServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.vitamContext = (VitamContext)Mockito.mock(VitamContext.class);
        this.adminExternalClient = (AdminExternalClient)Mockito.mock(AdminExternalClient.class);
        this.importSchemaCommonService = new ImportSchemaCommonService(this.adminExternalClient);
        this.objectMapper = new ObjectMapper();
    }

    @Test
    @DisplayName(value="Should throw AccessExternalClientException when import schema encounters an error")
    void importSchema_ShouldThrowAccessExternalClientException_OnError() throws Exception {
        Mockito.when((Object)this.vitamContext.getApplicationSessionId()).thenReturn((Object)"testSessionId");
        SchemaInputModel schemaModel = new SchemaInputModel();
        List<SchemaInputModel> schemaModels = Collections.singletonList(schemaModel);
        Mockito.when((Object)this.adminExternalClient.importUnitExternalSchema((VitamContext)Mockito.any(), (InputStream)Mockito.any())).thenThrow(AccessExternalClientException.class);
        org.junit.jupiter.api.Assertions.assertThrows(AccessExternalClientException.class, () -> this.importSchemaCommonService.importUnitSchema(this.vitamContext, schemaModels));
    }

    @Test
    @DisplayName(value="Should not throw an exception during schema serialization")
    void serializeImportSchema_ShouldNotThrowException() {
        SchemaInputModel schemaModel = new SchemaInputModel();
        schemaModel.setPath("testPath");
        schemaModel.setCardinality(SchemaCardinality.ONE);
        schemaModel.setObject(Boolean.valueOf(true));
        schemaModel.setShortName("testShortName");
        schemaModel.setDescription("testDescription");
        List<SchemaInputModel> schemaModels = Collections.singletonList(schemaModel);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.importSchemaCommonService.serializeImportSchema(schemaModels));
    }

    @Test
    @DisplayName(value="Should throw AccessExternalClientException for invalid schema")
    void importSchema_ShouldThrowExceptionForInvalidSchema() throws Exception {
        SchemaInputModel invalidSchemaModel = new SchemaInputModel();
        List<SchemaInputModel> invalidSchemaList = Collections.singletonList(invalidSchemaModel);
        Mockito.when((Object)this.adminExternalClient.importUnitExternalSchema((VitamContext)Mockito.any(), (InputStream)Mockito.any())).thenThrow(AccessExternalClientException.class);
        org.junit.jupiter.api.Assertions.assertThrows(AccessExternalClientException.class, () -> this.importSchemaCommonService.importUnitSchema(this.vitamContext, invalidSchemaList));
    }

    @Test
    @DisplayName(value="Should handle null schema list during serialization")
    void serializeImportSchema_ShouldHandleNullSchemaList() throws IOException {
        List nullSchemaList = null;
        ByteArrayInputStream result = this.importSchemaCommonService.serializeImportSchema(nullSchemaList);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
    }

    @Test
    @DisplayName(value="Should handle empty schema list during serialization")
    void serializeImportSchema_ShouldHandleEmptySchemaList() throws IOException {
        List emptySchemaList = Collections.emptyList();
        ByteArrayInputStream result = this.importSchemaCommonService.serializeImportSchema(emptySchemaList);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
    }

    @Test
    @DisplayName(value="Should throw IllegalArgumentException when import schema response is null")
    void importSchema_ShouldThrowException_WhenResponseIsNull() throws AccessExternalClientException, InvalidParseOperationException {
        SchemaInputModel schemaModel = new SchemaInputModel();
        schemaModel.setPath("testPath");
        List<SchemaInputModel> schemaModels = Collections.singletonList(schemaModel);
        Mockito.when((Object)this.adminExternalClient.importUnitExternalSchema((VitamContext)Mockito.any(), (InputStream)Mockito.any())).thenReturn(null);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.importSchemaCommonService.importUnitSchema(this.vitamContext, schemaModels));
    }

    @Test
    @DisplayName(value="Should generate valid JSON when serializing SchemaInputModel list")
    void testSerializeImportSchema_shouldGenerateValidJson() throws IOException {
        SchemaInputModel schema1 = new SchemaInputModel();
        schema1.setPath("path1");
        schema1.setDescription("description1");
        schema1.setCardinality(SchemaCardinality.ONE);
        schema1.setObject(Boolean.valueOf(true));
        schema1.setShortName("shortName1");
        SchemaInputModel schema2 = new SchemaInputModel();
        schema2.setPath("path2");
        schema2.setDescription("description2");
        schema2.setCardinality(SchemaCardinality.ONE);
        schema2.setObject(Boolean.valueOf(true));
        schema2.setShortName("shortName2");
        List<SchemaInputModel> schemaList = Arrays.asList(schema1, schema2);
        ByteArrayInputStream result = this.importSchemaCommonService.serializeImportSchema(schemaList);
        String jsonString = new String(result.readAllBytes());
        System.out.println(jsonString);
        Assertions.assertThat((String)jsonString).isNotNull();
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"Path\":\"path1\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"Description\":\"description1\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"Cardinality\":\"ONE\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"IsObject\":true"});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"ShortName\":\"shortName1\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"Path\":\"path2\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"Description\":\"description2\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"Cardinality\":\"ONE\""});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"IsObject\":true"});
        Assertions.assertThat((String)jsonString).contains(new CharSequence[]{"\"ShortName\":\"shortName2\""});
        List deserializedList = (List)this.objectMapper.readValue(jsonString, List.class);
        Assertions.assertThat((List)deserializedList).hasSize(2);
    }
}

