/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.common.dsl;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.QueryProjection;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.utils.ArchiveSearchConsts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class VitamQueryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamQueryHelper.class);

    public static void addParameterCriteria(BooleanQuery query, ArchiveSearchConsts.CriteriaOperators operator, String searchKey, List<String> searchValues) throws InvalidCreateOperationException {
        if (searchKey == null || "".equals(searchKey.trim())) {
            throw new InvalidCreateOperationException("searchKey is empty or null ");
        }
        if (CollectionUtils.isEmpty(searchValues)) {
            query.add(new Query[]{VitamQueryHelper.buildSubQueryByOperator(searchKey, null, operator)});
        } else if (searchValues.size() > 1) {
            BooleanQuery subQueryOr = QueryHelper.or();
            BooleanQuery subQueryAnd = QueryHelper.and();
            if (operator == ArchiveSearchConsts.CriteriaOperators.NOT_EQ) {
                for (String value : searchValues) {
                    subQueryAnd.add(new Query[]{VitamQueryHelper.buildSubQueryByOperator(searchKey, value, operator)});
                }
                query.add(new Query[]{subQueryAnd});
            } else {
                for (String value : searchValues) {
                    subQueryOr.add(new Query[]{VitamQueryHelper.buildSubQueryByOperator(searchKey, value, operator)});
                }
                query.add(new Query[]{subQueryOr});
            }
        } else if (searchValues.size() == 1) {
            query.add(new Query[]{VitamQueryHelper.buildSubQueryByOperator(searchKey, (String)searchValues.stream().findAny().get(), operator)});
        }
    }

    public static Query buildSubQueryByOperator(String searchKey, String value, ArchiveSearchConsts.CriteriaOperators operator) throws InvalidCreateOperationException {
        LOGGER.debug("buildSubQueryByOperator  searchKey : {}  value : {} operator : {} ", new Object[]{searchKey, value, operator});
        return switch (operator) {
            case ArchiveSearchConsts.CriteriaOperators.MATCH -> QueryHelper.match((String)searchKey, (String)value);
            case ArchiveSearchConsts.CriteriaOperators.GTE -> QueryHelper.gte((String)searchKey, (String)value);
            case ArchiveSearchConsts.CriteriaOperators.GT -> QueryHelper.gt((String)searchKey, (String)value);
            case ArchiveSearchConsts.CriteriaOperators.LTE -> QueryHelper.lte((String)searchKey, (String)value);
            case ArchiveSearchConsts.CriteriaOperators.LT -> QueryHelper.lt((String)searchKey, (String)value);
            case ArchiveSearchConsts.CriteriaOperators.NOT_EQ -> QueryHelper.ne((String)searchKey, (String)value);
            case ArchiveSearchConsts.CriteriaOperators.EXISTS -> QueryHelper.exists((String)searchKey);
            case ArchiveSearchConsts.CriteriaOperators.MISSING -> QueryHelper.missing((String)searchKey);
            case ArchiveSearchConsts.CriteriaOperators.IN -> {
                if (!ArchiveSearchConsts.APPRAISAL_MGT_RULES_FINAL_ACTION_TYPE_VALUES_MAPPING.containsValue(value)) {
                    yield QueryHelper.in((String)searchKey, (String[])new String[]{value});
                }
                yield QueryHelper.eq((String)searchKey, (String)value);
            }
            default -> QueryHelper.eq((String)searchKey, (String)value);
        };
    }

    public static JsonNode createQueryDSL(Map<String, Object> searchCriteriaMap, Optional<String> orderBy, Optional<DirectionDto> direction) throws InvalidParseOperationException, InvalidCreateOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and();
        BooleanQuery queryOr = QueryHelper.or();
        boolean isEmpty = true;
        boolean haveOrParameters = false;
        if (orderBy.isPresent()) {
            if (direction.isPresent() && DirectionDto.DESC.equals((Object)direction.get())) {
                select.addOrderByDescFilter(new String[]{orderBy.get()});
            } else {
                select.addOrderByAscFilter(new String[]{orderBy.get()});
            }
        }
        HashMap<String, Integer> projection = new HashMap<String, Integer>();
        projection.put("Identifier", 1);
        projection.put("Name", 1);
        QueryProjection queryProjection = new QueryProjection();
        queryProjection.setFields(projection);
        try {
            select.setProjection(JsonHandler.toJsonNode((Object)queryProjection));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error constructing vitam query : {}", (Throwable)e);
            throw new InvalidCreateOperationException("Invalid vitam query", (Throwable)e);
        }
        if (!searchCriteriaMap.isEmpty()) {
            isEmpty = false;
            Set<Map.Entry<String, Object>> entrySet = searchCriteriaMap.entrySet();
            block12: for (Map.Entry<String, Object> entry : entrySet) {
                String searchKey;
                switch (searchKey = entry.getKey()) {
                    case "Identifier": {
                        ArrayList stringsValues;
                        if (entry.getValue() instanceof ArrayList) {
                            stringsValues = (ArrayList)entry.getValue();
                            for (String elt : stringsValues) {
                                queryOr.add(new Query[]{QueryHelper.eq((String)searchKey, (String)elt)});
                            }
                            haveOrParameters = true;
                            continue block12;
                        }
                        if (!(entry.getValue() instanceof String)) continue block12;
                        String stringValue = (String)entry.getValue();
                        queryOr.add(new Query[]{QueryHelper.eq((String)searchKey, (String)stringValue)});
                        haveOrParameters = true;
                        continue block12;
                    }
                    case "Name": 
                    case "ShortName": 
                    case "#id": {
                        ArrayList stringsValues;
                        if (entry.getValue() instanceof ArrayList) {
                            stringsValues = (ArrayList)entry.getValue();
                            for (String name : stringsValues) {
                                queryOr.add(new Query[]{QueryHelper.matchPhrasePrefix((String)searchKey, (String)name)});
                            }
                            haveOrParameters = true;
                            continue block12;
                        }
                        if (!(entry.getValue() instanceof String)) continue block12;
                        String stringValue = (String)entry.getValue();
                        queryOr.add(new Query[]{QueryHelper.matchPhrasePrefix((String)searchKey, (String)stringValue)});
                        haveOrParameters = true;
                        continue block12;
                    }
                }
                LOGGER.error("Can not find binding for key: {}", (Object)searchKey);
            }
        }
        if (!isEmpty) {
            if (haveOrParameters) {
                query.add(new Query[]{queryOr});
            }
            select.setQuery((Query)query);
        }
        LOGGER.debug("Final query: {}", (Object)select.getFinalSelect().toPrettyString());
        return select.getFinalSelect();
    }
}

