/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.unit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.vitam.api.access.UnitCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.commons.vitam.api.model.UnitTypeEnum;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.service.ExternalParametersService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnitService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitService.class);
    private final UnitCommonService unitCommonService;
    private final ObjectMapper objectMapper;
    private static final String[] FILING_PLAN_PROJECTION = new String[]{"#id", "Title", "DescriptionLevel", "#unitType", "#unitups", "#allunitups", "#opi", "Keyword", "Vtag", "#object", "Title_"};
    private final ExternalParametersService externalParametersService;

    @Autowired
    public UnitService(UnitCommonService unitCommonService, ObjectMapper objectMapper, SecurityService securityService, ExternalParametersService externalParametersService) {
        super(securityService);
        this.unitCommonService = unitCommonService;
        this.objectMapper = objectMapper;
        this.externalParametersService = externalParametersService;
    }

    public JsonNode searchUnits(JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Unit EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.unitCommonService.searchUnits(dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode searchUnitsWithErrors(Optional<String> id, JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Unit EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.unitCommonService.searchUnitsWithErrors(id, dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode findObjectMetadataById(String unitId, JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        RequestResponse response = this.unitCommonService.findObjectMetadataById(unitId, dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode createQueryForFillingOrHoldingUnit() {
        try {
            SelectMultiQuery select = new SelectMultiQuery();
            InQuery query = QueryHelper.in((String)VitamFieldsHelper.unitType(), (String[])new String[]{UnitTypeEnum.HOLDING_UNIT.getValue(), UnitTypeEnum.FILING_UNIT.getValue()});
            select.addQueries(new Query[]{query});
            select.addUsedProjection(FILING_PLAN_PROJECTION);
            LOGGER.debug("query =", (Object)select.getFinalSelect().toPrettyString());
            return select.getFinalSelect();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new UnexpectedDataException("Unexpected error occurred while building holding dsl query : " + e.getMessage());
        }
    }

    public VitamUISearchResponseDto findUnitById(String id) throws VitamClientException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        VitamContext vitamContext = this.externalParametersService.buildVitamContextFromExternalParam();
        JsonNode response = this.unitCommonService.findUnitById(id, vitamContext).toJsonNode();
        try {
            return (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)response, VitamUISearchResponseDto.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public JsonNode findUnitByDsl(Optional<String> id, JsonNode dsl) throws VitamClientException {
        return this.searchUnitsWithErrors(id, dsl, this.buildVitamContext());
    }

    public JsonNode findObjectMetadataById(String id, JsonNode dsl) throws VitamClientException {
        return this.findObjectMetadataById(id, dsl, this.buildVitamContext());
    }

    public VitamUISearchResponseDto getFilingAndHoldingUnits() throws VitamClientException, JsonProcessingException {
        JsonNode fillingOrHoldingQuery = this.createQueryForFillingOrHoldingUnit();
        VitamContext vitamContext = this.externalParametersService.buildVitamContextFromExternalParam();
        return (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)this.searchUnits(fillingOrHoldingQuery, vitamContext), VitamUISearchResponseDto.class);
    }
}

