/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.schema;

import fr.gouv.vitam.common.model.administration.schema.SchemaCardinality;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.referential.common.dto.ImportSchemaDto;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportSchemaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportSchemaConverter.class);

    public SchemaInputModel convertDtoToVitam(ImportSchemaDto dto) {
        this.validateDto(dto);
        SchemaInputModel importSchema = (SchemaInputModel)VitamUIUtils.copyProperties((Object)dto, (Object)new SchemaInputModel());
        this.copyCustomProperties(dto, importSchema);
        return importSchema;
    }

    public ImportSchemaDto convertVitamToDto(SchemaInputModel schemaInputModel) {
        ImportSchemaDto dto = (ImportSchemaDto)VitamUIUtils.copyProperties((Object)schemaInputModel, (Object)new ImportSchemaDto());
        this.copyCustomProperties(schemaInputModel, dto);
        return dto;
    }

    public List<SchemaInputModel> convertDtosToVitams(List<ImportSchemaDto> dtos) {
        return dtos.stream().map(this::convertDtoToVitam).collect(Collectors.toList());
    }

    public List<ImportSchemaDto> convertVitamsToDtos(List<SchemaInputModel> importSchema) {
        return importSchema.stream().map(this::convertVitamToDto).collect(Collectors.toList());
    }

    void validateDto(ImportSchemaDto dto) {
        if (dto == null) {
            throw new IllegalArgumentException("DTO cannot be null");
        }
        if (dto.getCardinality() == null || dto.getCardinality().isBlank()) {
            throw new IllegalArgumentException("Cardinality cannot be null or blank");
        }
        try {
            SchemaCardinality.valueOf((String)dto.getCardinality());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid cardinality value: {}", (Object)dto.getCardinality(), (Object)e);
            throw new IllegalArgumentException("Invalid cardinality: " + dto.getCardinality(), e);
        }
    }

    private void copyCustomProperties(ImportSchemaDto dto, SchemaInputModel importSchema) {
        if (dto.getPath() != null) {
            importSchema.setPath(dto.getPath());
        }
        importSchema.setCardinality(SchemaCardinality.valueOf((String)dto.getCardinality()));
        importSchema.setObject(Boolean.valueOf(dto.isObject()));
        importSchema.setShortName(dto.getShortName());
        importSchema.setDescription(dto.getDescription());
    }

    void copyCustomProperties(SchemaInputModel schemaInputModel, ImportSchemaDto dto) {
        if (schemaInputModel.getPath() != null) {
            dto.setPath(schemaInputModel.getPath());
        }
        dto.setCardinality(String.valueOf(schemaInputModel.getCardinality()));
        dto.setObject(schemaInputModel.isObject().booleanValue());
        dto.setShortName(schemaInputModel.getShortName());
        dto.setDescription(schemaInputModel.getDescription());
    }
}

