/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.schema;

import fr.gouv.vitamui.referential.common.model.Cardinality;
import fr.gouv.vitamui.referential.server.service.utils.ImportCSVUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class ImportSchemaCSVUtils
extends ImportCSVUtils {
    public static final String PATH = "Path";
    public static final String CARDINALITY = "Cardinality";
    public static final String ISOBJECT = "IsObject";
    public static final String SHORTNAME = "ShortName";
    public static final String DESCRIPTION = "Description";

    private ImportSchemaCSVUtils() {
    }

    public static void checkImportFile(MultipartFile importSchemaFile) {
        ImportSchemaCSVUtils.checkImportFile(importSchemaFile, ImportSchemaCSVUtils.buildImportSchemaColumns());
    }

    static List<ImportCSVUtils.ColumnDetails> buildImportSchemaColumns() {
        ArrayList<ImportCSVUtils.ColumnDetails> expectedColumns = new ArrayList<ImportCSVUtils.ColumnDetails>();
        expectedColumns.add(ImportCSVUtils.ColumnDetails.builder().index(0).columnName(PATH).columnType(ImportCSVUtils.ColumnType.STRING).mandatory(true).build());
        expectedColumns.add(ImportCSVUtils.ColumnDetails.builder().index(1).columnName(CARDINALITY).columnType(ImportCSVUtils.ColumnType.STRING).mandatory(true).allowedValues(Arrays.stream(Cardinality.values()).map(Enum::name).toList()).build());
        expectedColumns.add(ImportCSVUtils.ColumnDetails.builder().index(2).columnName(ISOBJECT).columnType(ImportCSVUtils.ColumnType.STRING).mandatory(false).build());
        expectedColumns.add(ImportCSVUtils.ColumnDetails.builder().index(3).columnName(SHORTNAME).columnType(ImportCSVUtils.ColumnType.STRING).mandatory(true).build());
        expectedColumns.add(ImportCSVUtils.ColumnDetails.builder().index(4).columnName(DESCRIPTION).columnType(ImportCSVUtils.ColumnType.STRING).mandatory(true).build());
        return expectedColumns;
    }
}

