/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.schema;

import com.fasterxml.jackson.databind.util.StdConverter;
import fr.gouv.vitam.common.model.administration.CombinedSchemaModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaStringSizeType;
import fr.gouv.vitamui.referential.common.dto.ControlDto;
import fr.gouv.vitamui.referential.common.dto.SchemaElementDto;
import fr.gouv.vitamui.referential.common.model.Cardinality;
import fr.gouv.vitamui.referential.common.model.Collection;
import fr.gouv.vitamui.referential.common.model.ControlType;
import fr.gouv.vitamui.referential.common.model.DataType;
import fr.gouv.vitamui.referential.common.model.EffectiveCardinality;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedSchemaModelToSchemaElementDtoConverter
extends StdConverter<CombinedSchemaModel, SchemaElementDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CombinedSchemaModelToSchemaElementDtoConverter.class);

    public SchemaElementDto convert(CombinedSchemaModel schemaModel) {
        SchemaStringSizeType stringTypeSize = null;
        if (schemaModel.getStringSize() != null) {
            stringTypeSize = SchemaStringSizeType.fromValue((String)schemaModel.getStringSize().name());
        }
        SchemaElementDto schemaElementDto = (SchemaElementDto)new SchemaElementDto().setPath(schemaModel.getPath()).setStringSize((String)Optional.ofNullable(stringTypeSize).map(SchemaStringSizeType::value).orElse(null)).setCardinality(Cardinality.valueOf((String)schemaModel.getCardinality().name())).setFieldName(schemaModel.getFieldName()).setShortName(schemaModel.getShortName()).setDescription(schemaModel.getDescription()).setSedaField(schemaModel.getSedaField()).setApiField(schemaModel.getApiField()).setType(schemaModel.getType()).setOrigin(schemaModel.getOrigin()).setCollection(this.mapCollections(schemaModel)).setSedaVersions(schemaModel.getSedaVersions()).setCategory(schemaModel.getCategory()).setApiPath(Optional.ofNullable(schemaModel.getApiPath()).orElse(schemaModel.getPath())).setDataType(this.convertFromIndexationType(schemaModel.getType().name())).setCustomSearchTypes(schemaModel.getCustomSearchTypes());
        schemaElementDto.setEffectiveCardinality(EffectiveCardinality.valueOf((String)schemaModel.getEffectiveCardinality()));
        if (schemaModel.getControl() == null) {
            return schemaElementDto;
        }
        ControlDto controlDto = new ControlDto();
        if (schemaModel.getControl().getType() != null) {
            controlDto.setType(ControlType.valueOf((String)schemaModel.getControl().getType()));
        }
        controlDto.setValue(schemaModel.getControl().getValue());
        controlDto.setValues(schemaModel.getControl().getValues());
        controlDto.setComment(schemaModel.getControl().getComment());
        schemaElementDto.setControl(controlDto);
        return schemaElementDto;
    }

    private DataType convertFromIndexationType(String indexationType) {
        switch (indexationType) {
            case "KEYWORD": 
            case "ENUM": 
            case "TEXT": {
                return DataType.STRING;
            }
            case "DATE": {
                return DataType.DATETIME;
            }
            case "OBJECT": 
            case "LONG": 
            case "DOUBLE": 
            case "BOOLEAN": {
                return DataType.valueOf((String)indexationType);
            }
        }
        return null;
    }

    private Collection mapCollections(CombinedSchemaModel schemaResponse) {
        if (Objects.isNull(schemaResponse.getCollection())) {
            return null;
        }
        if (Objects.equals(schemaResponse.getCollection(), "Unit")) {
            return Collection.ARCHIVE_UNIT;
        }
        return Collection.valueOf((String)schemaResponse.getCollection());
    }
}

