/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.operation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.LogbookEventModel;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.common.model.AuditCreateOptions;
import fr.gouv.vitamui.referential.common.service.OperationCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.operation.OperationConverter;
import fr.gouv.vitamui.referential.server.service.probativevalue.ProbativeValueService;
import fr.gouv.vitamui.referential.server.service.service.ExternalParametersService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class OperationService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationService.class);
    private final OperationCommonService operationCommonService;
    private final LogbookService logbookService;
    private ProbativeValueService probativeValueService;
    private final ExternalParametersService externalParametersService;
    private final String AUDIT_FILE_CONSISTENCY = "AUDIT_FILE_CONSISTENCY";
    private final String AUDIT_FILE_RECTIFICATION = "AUDIT_FILE_RECTIFICATION";
    private final String AUDIT_FILE_INTEGRITY = "AUDIT_FILE_INTEGRITY";
    private final String AUDIT_FILE_EXISTING = "AUDIT_FILE_EXISTING";
    private final List<String> AUDITS_WITHOUT_PROJECTION = List.of("AUDIT_FILE_INTEGRITY", "AUDIT_FILE_EXISTING");
    public static final String DSL_QUERY_PROJECTION = "$projection";
    public static final String DSL_QUERY_FILTER = "$filter";
    public static final String DSL_QUERY_FACETS = "$facets";
    private final ObjectMapper objectMapper;
    private final String AUDIT_PERIMETER_INGEST_OPERATION_PERIOD = "AUDIT_PERIMETER_INGEST_OPERATION_PERIOD";
    public static final String DSL_QUERY = "$query";
    public static final String DSL_QUERY_FIELDS = "$fields";
    public static final String DSL_QUERY_EVID = "evId";
    public static final String APPROXIMATE_CREATION_DATE = "#approximate_creation_date";
    public static final String EV_DATE_TIME = "evDateTime";
    public static final String EV_TYPE_PROC = "evTypeProc";
    public static final String INGEST = "INGEST";
    private final String START_TIME = "T00:00:00.000";
    private final String END_TIME = "T23:59:59.999";

    @Autowired
    public OperationService(OperationCommonService operationCommonService, LogbookService logbookService, ObjectMapper objectMapper, ExternalParametersService externalParametersService, SecurityService securityService, ProbativeValueService probativeValueService) {
        super(securityService);
        this.operationCommonService = operationCommonService;
        this.logbookService = logbookService;
        this.objectMapper = objectMapper;
        this.externalParametersService = externalParametersService;
        this.probativeValueService = probativeValueService;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Map vitamCriteria = new HashMap();
        LOGGER.info("All Operations EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find LogbookOperations with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        LogbookOperationsResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<LogbookOperationDto> valuesDto = OperationConverter.convertVitamsToDtos(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private LogbookOperationsResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Operations EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperations(query, vitamContext);
            LogbookOperationsResponseDto logbookOperationsResponseDto = (LogbookOperationsResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), LogbookOperationsResponseDto.class);
            return logbookOperationsResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find LogbookOperations", e);
        }
    }

    public void runAudit(VitamContext context, AuditCreateOptions auditCreateOptions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            Optional<Long> thresholdOpt = this.externalParametersService.retrieveProfilThreshold();
            LOGGER.info("All Operations Audit EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            if ("AUDIT_FILE_RECTIFICATION".equals(auditCreateOptions.getAuditActions())) {
                this.operationCommonService.launchRectificationAudit(context, auditCreateOptions.getObjectId());
            } else {
                AuditOptions auditOptions = this.updateAuditDslQuery(auditCreateOptions, thresholdOpt, context);
                if ("AUDIT_FILE_CONSISTENCY".equals(auditOptions.getAuditActions())) {
                    this.operationCommonService.lauchEvidenceAudit(context, auditOptions.getQuery());
                } else {
                    this.operationCommonService.runAudit(context, mapper.valueToTree((Object)auditOptions));
                }
            }
        }
        catch (AccessExternalClientServerException | VitamClientException | BadRequestException e) {
            throw new InternalServerException("Unable to run audit", e);
        }
    }

    public AuditOptions updateAuditDslQuery(AuditCreateOptions auditCreateOptions, Optional<Long> thresholdOpt, VitamContext context) {
        SelectMultiQuery multiQuery = new SelectMultiQuery();
        AuditOptions auditOptions = new AuditOptions();
        auditOptions.setAuditType(auditCreateOptions.getAuditType());
        auditOptions.setAuditActions(auditCreateOptions.getAuditActions());
        auditOptions.setObjectId(auditCreateOptions.getObjectId());
        auditOptions.setAuditType("dsl");
        try {
            if (!"dsl".equals(auditOptions.getAuditType()) || null == thresholdOpt) {
                throw new InvalidCreateOperationException("Invalid audit query");
            }
            BooleanQuery and = QueryHelper.and();
            if (!"AUDIT_PERIMETER_INGEST_OPERATION_PERIOD".equals(auditCreateOptions.getAuditPerimeter())) {
                if (CollectionUtils.isNotEmpty(Arrays.stream(auditCreateOptions.getOriginatingAgencyIds()).toList())) {
                    and.add(new Query[]{QueryHelper.in((String)"#originating_agency", (String[])auditCreateOptions.getOriginatingAgencyIds())});
                }
                if (CollectionUtils.isNotEmpty(Arrays.stream(auditCreateOptions.getAttachmentPositionIds()).toList())) {
                    and.add(new Query[]{QueryHelper.in((String)"#allunitups", (String[])auditCreateOptions.getAttachmentPositionIds())});
                }
                if (CollectionUtils.isNotEmpty(Arrays.stream(auditCreateOptions.getIngestOperationIds()).toList())) {
                    and.add(new Query[]{QueryHelper.in((String)"#operations", (String[])auditCreateOptions.getIngestOperationIds())});
                }
                if (StringUtils.isNotEmpty((CharSequence)auditCreateOptions.getStartDate())) {
                    fullDate = auditCreateOptions.getStartDate().concat("T00:00:00.000");
                    and.add(new Query[]{QueryHelper.gte((String)APPROXIMATE_CREATION_DATE, (String)fullDate)});
                }
                if (StringUtils.isNotEmpty((CharSequence)auditCreateOptions.getEndDate())) {
                    fullDate = auditCreateOptions.getEndDate().concat("T23:59:59.999");
                    and.add(new Query[]{QueryHelper.lte((String)APPROXIMATE_CREATION_DATE, (String)fullDate)});
                }
                multiQuery.setQuery((Query)and);
            } else {
                if (StringUtils.isNotEmpty((CharSequence)auditCreateOptions.getStartDate())) {
                    fullDate = auditCreateOptions.getStartDate().concat("T00:00:00.000");
                    and.add(new Query[]{QueryHelper.gte((String)EV_DATE_TIME, (String)fullDate)});
                }
                if (StringUtils.isNotEmpty((CharSequence)auditCreateOptions.getEndDate())) {
                    fullDate = auditCreateOptions.getEndDate().concat("T23:59:59.999");
                    and.add(new Query[]{QueryHelper.lte((String)EV_DATE_TIME, (String)fullDate)});
                }
                and.add(new Query[]{QueryHelper.eq((String)EV_TYPE_PROC, (String)INGEST)});
                ObjectNode queryNode = JsonHandler.createObjectNode();
                ObjectNode projectionNode = JsonHandler.createObjectNode();
                ObjectNode fieldsNode = JsonHandler.createObjectNode();
                queryNode.put(DSL_QUERY, (JsonNode)and.getCurrentQuery());
                fieldsNode.put(DSL_QUERY_EVID, 1);
                projectionNode.put(DSL_QUERY_FIELDS, (JsonNode)fieldsNode);
                queryNode.put(DSL_QUERY_PROJECTION, (JsonNode)projectionNode);
                LogbookOperationsResponseDto response = this.findAll(context, (JsonNode)queryNode);
                String[] ingestIds = (String[])response.getResults().stream().map(LogbookEventModel::getId).toArray(String[]::new);
                BooleanQuery finalAnd = QueryHelper.and();
                finalAnd.add(new Query[]{QueryHelper.in((String)"#operations", (String[])ingestIds)});
                multiQuery.setQuery((Query)finalAnd);
            }
            auditOptions.setQuery((JsonNode)multiQuery.getFinalSelect());
            if (thresholdOpt.isPresent()) {
                ObjectNode previousDslQuery = (ObjectNode)auditOptions.getQuery();
                previousDslQuery.put("$threshold", thresholdOpt.get());
                auditOptions.setQuery((JsonNode)previousDslQuery);
            }
            Arrays.stream(new String[]{DSL_QUERY_PROJECTION, DSL_QUERY_FILTER, DSL_QUERY_FACETS}).forEach(arg_0 -> ((ObjectNode)((ObjectNode)auditOptions.getQuery())).remove(arg_0));
            if (!this.AUDITS_WITHOUT_PROJECTION.contains(auditOptions.getAuditActions())) {
                ObjectNode dslQueryProjection = (ObjectNode)auditOptions.getQuery();
                dslQueryProjection.put(DSL_QUERY_PROJECTION, this.objectMapper.readTree("{}"));
                auditOptions.setQuery((JsonNode)dslQueryProjection);
            }
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error(e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOGGER.error(e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
        return auditOptions;
    }

    public Response export(VitamContext context, String id, ReportType type) {
        try {
            LOGGER.info("Export  Operations EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            switch (type) {
                case AUDIT: {
                    return this.operationCommonService.exportAudit(context, id);
                }
                case TRACEABILITY: {
                    return this.operationCommonService.exportTraceability(context, id);
                }
            }
            throw new InternalServerException("Unable to  export that kind of report: " + String.valueOf(type));
        }
        catch (AccessExternalClientServerException | VitamClientException e) {
            throw new InternalServerException("Unable to export operation report", e);
        }
    }

    public JsonNode checkTraceabilityOperation(VitamContext vitamContext, String id) {
        Select select = new Select();
        try {
            BooleanQuery query = QueryHelper.and();
            query.add(new Query[]{QueryHelper.eq((String)"evIdProc", (String)id)});
            select.setQuery((Query)query);
            RequestResponse response = this.logbookService.checkTraceability(vitamContext, (JsonNode)select.getFinalSelect());
            return response.toJsonNode();
        }
        catch (AccessExternalClientServerException | InvalidCreateOperationException | AccessUnauthorizedException | InvalidParseOperationException e) {
            throw new InternalServerException("Unable to check traceability operation", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) {
        try {
            LOGGER.info("Operation History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperationbyId(id, vitamContext);
            return requestResponse.toJsonNode();
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public void runProbativeValue(VitamContext context, ProbativeValueRequest probativeValueRequest) {
        try {
            LOGGER.info("All Operations Probative Value EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            this.operationCommonService.runProbativeValue(context, probativeValueRequest);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Unable to generate Probative value", (Throwable)e);
        }
    }

    public List<LogbookOperationDto> getAll(Optional<String> criteria) {
        JsonNode query;
        VitamContext vitamContext = this.buildVitamContext();
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, null, null, Optional.empty(), Optional.empty());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find LogbookOperations with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        return OperationConverter.convertVitamsToDtos(this.findAll(vitamContext, query).getResults());
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    public boolean runAudit(AuditCreateOptions auditOptions) {
        VitamContext vitamContext = this.buildVitamContext();
        this.runAudit(vitamContext, auditOptions);
        return true;
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode history = this.findHistoryByIdentifier(vitamContext, id);
        try {
            return (LogbookOperationsCommonResponseDto)this.objectMapper.treeToValue((TreeNode)history, LogbookOperationsCommonResponseDto.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error parsing history data", (Throwable)e);
        }
    }

    public ResponseEntity<Resource> export(String id, ReportType type) {
        VitamContext vitamContext = this.buildVitamContext();
        Response response = this.export(vitamContext, id, type);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            InputStreamResource resource = new InputStreamResource((InputStream)entity);
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        return null;
    }

    public JsonNode checkTraceabilityOperation(String id) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.checkTraceabilityOperation(vitamContext, id);
    }

    public boolean runProbativeValue(ProbativeValueRequest probativeValueRequest) {
        VitamContext vitamContext = this.buildVitamContext();
        this.runProbativeValue(vitamContext, probativeValueRequest);
        return true;
    }

    public ResponseEntity<Resource> exportProbativeValue(String operationId) throws PreconditionFailedException {
        VitamContext vitamContext = this.buildVitamContext();
        String tempFolder = "/tmp/" + operationId + ".zip";
        File zip = new File(tempFolder);
        try {
            FileOutputStream zipOutputStream = new FileOutputStream(zip);
            this.probativeValueService.exportReport(vitamContext, operationId, "/tmp", zipOutputStream);
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(zip.getAbsoluteFile()));
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        catch (FileNotFoundException e) {
            throw new InternalServerException("Error while generating probative value ZIP", (Throwable)e);
        }
    }
}

