/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.ontology;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.OntologyOrigin;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitam.common.model.administration.StringSize;
import fr.gouv.vitam.common.model.administration.TypeDetail;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.utils.OntologyServiceReader;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.common.dto.OntologyResponseDto;
import fr.gouv.vitamui.referential.common.service.OntologyCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.ontology.OntologyConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OntologyService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyService.class);
    private OntologyCommonService ontologyCommonService;
    private ObjectMapper objectMapper;
    private OntologyConverter converter;
    private LogbookService logbookService;
    @Value(value="${internal_ontology_file_path}")
    private String internalOntologieFilePath;

    @Autowired
    public OntologyService(OntologyCommonService ontologyCommonService, ObjectMapper objectMapper, OntologyConverter converter, LogbookService logbookService, SecurityService securityService) {
        super(securityService);
        this.ontologyCommonService = ontologyCommonService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
    }

    public OntologyDto getOne(VitamContext vitamContext, String identifier) {
        try {
            RequestResponse requestResponse = this.ontologyCommonService.findOntologyById(vitamContext, identifier);
            OntologyResponseDto accessContractResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            if (accessContractResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((OntologyModel)accessContractResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Ontology", e);
        }
    }

    public List<OntologyDto> getAll(VitamContext vitamContext) {
        try {
            RequestResponse requestResponse = this.ontologyCommonService.findOntologies(vitamContext, (JsonNode)new Select().getFinalSelect());
            OntologyResponseDto ontologyResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            return this.converter.convertVitamsToDtos(ontologyResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find ontologies", e);
        }
    }

    public PaginatedValuesDto<OntologyDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find ontologies with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        OntologyResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<OntologyDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private OntologyResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            RequestResponse requestResponse = this.ontologyCommonService.findOntologies(vitamContext, query);
            OntologyResponseDto ontologyResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            return ontologyResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find ontologies", e);
        }
    }

    public Boolean check(VitamContext vitamContext, OntologyDto ontologyDto) {
        try {
            return !this.ontologyCommonService.checkAbilityToCreateOntologyInVitam(this.converter.convertDtosToVitams(Arrays.asList(ontologyDto)), vitamContext);
        }
        catch (ConflictException e) {
            return true;
        }
    }

    public OntologyDto create(VitamContext context, OntologyDto ontologyDto) {
        List<OntologyDto> ontologies = this.getAll(context);
        ontologyDto.setOrigin(OntologyOrigin.EXTERNAL);
        ontologies.add(ontologyDto);
        try {
            RequestResponse requestResponse = this.ontologyCommonService.importOntologies(context, this.converter.convertDtosToVitams(ontologies));
            VitamRestUtils.checkResponse((RequestResponse)requestResponse, (Integer[])new Integer[0]);
            OntologyResponseDto ontologyResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            List<OntologyDto> ontologyDtos = this.converter.convertVitamsToDtos(ontologyResponseDto.getResults());
            return ontologyDtos == null || ontologyDtos.isEmpty() ? ontologyDto : ontologyDtos.get(0);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to create ontology", e);
        }
    }

    public void delete(VitamContext context, String identifier) {
        List<OntologyDto> ontologies = this.getAll(context);
        try {
            RequestResponse requestResponse = this.ontologyCommonService.importOntologies(context, this.converter.convertDtosToVitams(ontologies.stream().filter(ontologyDto -> !ontologyDto.getId().equals(identifier) || !OntologyOrigin.EXTERNAL.equals((Object)ontologyDto.getOrigin())).collect(Collectors.toList())));
            VitamRestUtils.checkResponse((RequestResponse)requestResponse, (Integer[])new Integer[0]);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to delete ontology", e);
        }
    }

    public OntologyDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        try {
            if (vitamContext != null) {
                LOGGER.info("Update Ontology EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            }
            List<OntologyDto> ontologies = this.getAll(vitamContext);
            OntologyDto ontologyDto = ontologies.stream().filter(ontology -> partialDto.get("id").equals(ontology.getId())).findFirst().orElseThrow(() -> new InternalServerException("No ontology matched for update"));
            this.patchFields(ontologyDto, partialDto);
            this.ontologyCommonService.importOntologies(vitamContext, this.converter.convertDtosToVitams(ontologies));
            return ontologyDto;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to patch agency", e);
        }
    }

    private void patchFields(OntologyDto ontologyToPatch, Map<String, Object> fieldsToApply) {
        if (fieldsToApply.containsKey("shortName")) {
            ontologyToPatch.setShortName((String)fieldsToApply.get("shortName"));
        }
        if (fieldsToApply.containsKey("description")) {
            ontologyToPatch.setDescription((String)fieldsToApply.get("description"));
        }
        if (fieldsToApply.containsKey("type")) {
            ontologyToPatch.setType(OntologyType.valueOf((String)((String)fieldsToApply.get("type"))));
        }
        if (fieldsToApply.containsKey("typeDetail")) {
            ontologyToPatch.setTypeDetail(TypeDetail.valueOf((String)((String)fieldsToApply.get("typeDetail"))));
        }
        if (fieldsToApply.containsKey("stringSize")) {
            ontologyToPatch.setStringSize((StringSize)Optional.ofNullable(fieldsToApply.get("stringSize")).map(v -> StringSize.valueOf((String)((String)v))).orElse(null));
        }
        if (fieldsToApply.containsKey("collections")) {
            ontologyToPatch.setCollections((List)fieldsToApply.get("collections"));
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        try {
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public JsonNode importOntologies(VitamContext context, String fileName, MultipartFile file) {
        try {
            RequestResponse requestResponse = this.ontologyCommonService.importOntologies(context, fileName, file);
            VitamRestUtils.checkResponse((RequestResponse)requestResponse, (Integer[])new Integer[]{200, 204});
            return requestResponse.toJsonNode();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to import ontology file " + fileName + " : ", e);
        }
    }

    public List<VitamUiOntologyDto> readInternalOntologyFromFile() throws IOException {
        LOGGER.debug("get default internal ontologie file from path : {} ", (Object)this.internalOntologieFilePath);
        return OntologyServiceReader.readInternalOntologyFromFile((String)this.internalOntologieFilePath);
    }

    public OntologyDto getOne(String identifier) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, identifier);
    }

    public List<OntologyDto> getAll() {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public PaginatedValuesDto<OntologyDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    public Boolean check(OntologyDto ontologyDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, ontologyDto);
    }

    public OntologyDto create(OntologyDto ontologyDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, ontologyDto);
    }

    public void delete(String identifier) {
        VitamContext vitamContext = this.buildVitamContext();
        this.delete(vitamContext, identifier);
    }

    public OntologyDto patch(Map<String, Object> partialDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, partialDto);
    }

    public JsonNode importOntologies(String fileName, MultipartFile file) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.importOntologies(vitamContext, fileName, file);
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String id) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode body = this.findHistoryByIdentifier(vitamContext, id);
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }
}

