/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.managementcontract;

import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicy;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicyTypeEnum;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierUsage;
import fr.gouv.vitam.common.model.administration.StorageDetailModel;
import fr.gouv.vitam.common.model.administration.VersionRetentionPolicyModel;
import fr.gouv.vitam.common.model.administration.VersionUsageModel;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PersistentIdentifierPolicyMgtContractDto;
import fr.gouv.vitamui.commons.api.domain.PersistentIdentifierUsageMgtContractDto;
import fr.gouv.vitamui.commons.api.domain.StorageManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.VersionRetentionPolicyMgtContractDto;
import fr.gouv.vitamui.commons.api.domain.VersionUsageMgtContractDto;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class ManagementContractDtoToModelConverter
implements Converter<ManagementContractDto, ManagementContractModel> {
    public ManagementContractModel convert(@NotNull ManagementContractDto source) {
        ManagementContractModel managementContractModel = new ManagementContractModel();
        this.copyBasicProperties(source, managementContractModel);
        managementContractModel.setStorage(this.convertStorage(source.getStorage()));
        managementContractModel.setVersionRetentionPolicy(this.convertVersionRetentionPolicy(source.getVersionRetentionPolicy()));
        managementContractModel.setPersistentIdentifierPolicyList(this.convertPersistentIdentifierPolicies(source.getPersistentIdentifierPolicyList()));
        return managementContractModel;
    }

    private void copyBasicProperties(ManagementContractDto source, ManagementContractModel target) {
        target.setTenant(source.getTenant());
        target.setVersion(source.getVersion());
        target.setName(source.getName());
        target.setIdentifier(source.getIdentifier());
        target.setDescription(source.getDescription());
        target.setStatus(source.getStatus() != null ? Enum.valueOf(ActivationStatus.class, source.getStatus()) : null);
        target.setCreationdate(source.getCreationDate());
        target.setLastupdate(source.getLastUpdate());
        target.setDeactivationdate(source.getDeactivationDate());
        target.setActivationdate(source.getActivationDate());
    }

    private StorageDetailModel convertStorage(StorageManagementContractDto storageDto) {
        if (storageDto == null) {
            return null;
        }
        StorageDetailModel storageModel = new StorageDetailModel();
        storageModel.setUnitStrategy(storageDto.getUnitStrategy());
        storageModel.setObjectGroupStrategy(storageDto.getObjectGroupStrategy());
        storageModel.setObjectStrategy(storageDto.getObjectStrategy());
        return storageModel;
    }

    private VersionRetentionPolicyModel convertVersionRetentionPolicy(VersionRetentionPolicyMgtContractDto dto) {
        if (dto == null) {
            return null;
        }
        VersionRetentionPolicyModel versionRetentionPolicyModel = new VersionRetentionPolicyModel();
        versionRetentionPolicyModel.setInitialVersion(dto.isInitialVersion());
        versionRetentionPolicyModel.setIntermediaryVersion(Optional.ofNullable(dto.getIntermediaryVersion()).map(intermediaryVersionDto -> Enum.valueOf(VersionUsageModel.IntermediaryVersionEnum.class, intermediaryVersionDto.name())).orElseThrow());
        versionRetentionPolicyModel.setUsages(this.convertVersionUsages(dto.getUsages()));
        return versionRetentionPolicyModel;
    }

    private Set<VersionUsageModel> convertVersionUsages(Set<VersionUsageMgtContractDto> usageDtos) {
        if (usageDtos == null) {
            return null;
        }
        return usageDtos.stream().map(this::convertVersionUsage).collect(Collectors.toSet());
    }

    private VersionUsageModel convertVersionUsage(VersionUsageMgtContractDto dto) {
        if (dto == null) {
            return null;
        }
        VersionUsageModel versionUsageModel = new VersionUsageModel();
        versionUsageModel.setUsageName(dto.getUsageName());
        versionUsageModel.setInitialVersion(dto.isInitialVersion());
        versionUsageModel.setIntermediaryVersion(Optional.ofNullable(dto.getIntermediaryVersion()).map(intermediaryVersionDto -> Enum.valueOf(VersionUsageModel.IntermediaryVersionEnum.class, intermediaryVersionDto.name())).orElseThrow());
        return versionUsageModel;
    }

    private List<PersistentIdentifierPolicy> convertPersistentIdentifierPolicies(List<PersistentIdentifierPolicyMgtContractDto> policyDtos) {
        if (policyDtos == null) {
            return null;
        }
        return policyDtos.stream().map(this::convertPersistentIdentifierPolicy).collect(Collectors.toList());
    }

    private PersistentIdentifierPolicy convertPersistentIdentifierPolicy(PersistentIdentifierPolicyMgtContractDto dto) {
        if (dto == null) {
            return null;
        }
        PersistentIdentifierPolicy policy = new PersistentIdentifierPolicy();
        policy.setPersistentIdentifierAuthority(dto.getPersistentIdentifierAuthority());
        policy.setPersistentIdentifierUnit(dto.isPersistentIdentifierUnit());
        policy.setPersistentIdentifierPolicyType(Optional.ofNullable(dto.getPersistentIdentifierPolicyType()).map(policyTypeDto -> Enum.valueOf(PersistentIdentifierPolicyTypeEnum.class, policyTypeDto)).orElseThrow());
        policy.setPersistentIdentifierUsages(this.convertPersistentIdentifierUsages(dto.getPersistentIdentifierUsages()));
        return policy;
    }

    private List<PersistentIdentifierUsage> convertPersistentIdentifierUsages(List<PersistentIdentifierUsageMgtContractDto> usageDtos) {
        if (usageDtos == null) {
            return null;
        }
        return usageDtos.stream().map(this::convertPersistentIdentifierUsage).collect(Collectors.toList());
    }

    private PersistentIdentifierUsage convertPersistentIdentifierUsage(PersistentIdentifierUsageMgtContractDto dto) {
        if (dto == null) {
            return null;
        }
        PersistentIdentifierUsage usage = new PersistentIdentifierUsage();
        usage.setUsageName(Optional.ofNullable(dto.getUsageName()).map(DataObjectVersionType::fromName).orElseThrow());
        usage.setInitialVersion(dto.isInitialVersion());
        usage.setIntermediaryVersion(Optional.ofNullable(dto.getIntermediaryVersion()).map(intermediaryVersionDto -> Enum.valueOf(VersionUsageModel.IntermediaryVersionEnum.class, intermediaryVersionDto.name())).orElseThrow());
        return usage;
    }
}

