/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.logbookmanagement;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitamui.commons.api.enums.OperationActionStatus;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.vitam.api.administration.VitamOperationCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.ProcessDetailDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUIProcessDetailResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogbookManagementOperationService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogbookManagementOperationService.class);
    private static final String START_MAX_DATE = "30/12/2999";
    private static final String START_MIN_DATE = "01/01/1900";
    private ObjectMapper objectMapper;
    private VitamOperationCommonService vitamOperationCommonService;

    @Autowired
    public LogbookManagementOperationService(ObjectMapper objectMapper, VitamOperationCommonService vitamOperationCommonService, SecurityService securityService) {
        super(securityService);
        this.objectMapper = objectMapper;
        this.vitamOperationCommonService = vitamOperationCommonService;
    }

    public ProcessDetailDto searchOperationsDetails(VitamContext vitamContext, ProcessQuery processQuery) throws VitamClientException, JsonProcessingException {
        LOGGER.info("Get Operations Details with processQuery = {}", (Object)processQuery);
        if (processQuery.getStartDateMax() == null) {
            processQuery.setStartDateMax(START_MAX_DATE);
        }
        if (processQuery.getStartDateMin() == null) {
            processQuery.setStartDateMin(START_MIN_DATE);
        }
        JsonNode response = this.vitamOperationCommonService.listOperationsDetails(vitamContext, processQuery).toJsonNode();
        VitamUIProcessDetailResponseDto processDetailResponse = (VitamUIProcessDetailResponseDto)this.objectMapper.treeToValue((TreeNode)response, VitamUIProcessDetailResponseDto.class);
        VitamUIProcessDetailResponseDto responseFilled = new VitamUIProcessDetailResponseDto();
        responseFilled.setContext(processDetailResponse.getContext());
        responseFilled.setFacetResults(processDetailResponse.getFacetResults());
        responseFilled.setResults(processDetailResponse.getResults());
        responseFilled.setHits(processDetailResponse.getHits());
        return new ProcessDetailDto(responseFilled);
    }

    public ProcessDetailDto updateOperationActionProcess(VitamContext vitamContext, String actionId, String operationId) throws VitamClientException, JsonProcessingException, InterruptedException {
        LOGGER.info("Update operation Id= {} with the action Id= {}", (Object)operationId, (Object)actionId);
        if (!EnumUtils.isValidEnum(OperationActionStatus.class, (String)actionId)) {
            LOGGER.error("Cannot update  the operation, because the actionId= {} given is not correct ", (Object)actionId);
            throw new VitamClientException("Cannot update  the operation, because the actionId given is not correct");
        }
        this.vitamOperationCommonService.updateOperationActionProcess(vitamContext, actionId, operationId);
        ProcessQuery processQuery = new ProcessQuery();
        processQuery.setId(operationId);
        ProcessDetailDto operation = this.searchOperationsDetails(vitamContext, processQuery);
        return operation;
    }

    public ProcessDetailDto cancelOperationProcessExecution(VitamContext vitamContext, String operationId) throws VitamClientException, JsonProcessingException {
        LOGGER.info("Cancel the operation Id=  {}", (Object)operationId);
        this.vitamOperationCommonService.cancelOperationProcessExecution(vitamContext, operationId);
        ProcessQuery processQuery = new ProcessQuery();
        processQuery.setId(operationId);
        ProcessDetailDto operation = this.searchOperationsDetails(vitamContext, processQuery);
        return operation;
    }

    public ProcessDetailDto searchOperationsDetails(ProcessQuery processQuery) {
        VitamContext vitamContext = this.buildVitamContext();
        try {
            return this.searchOperationsDetails(vitamContext, processQuery);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to search operation details", e);
        }
    }

    public ProcessDetailDto updateOperationActionProcess(String actionId, String operationId) {
        VitamContext vitamContext = this.buildVitamContext();
        try {
            return this.updateOperationActionProcess(vitamContext, actionId, operationId);
        }
        catch (JsonProcessingException | VitamClientException | InterruptedException e) {
            throw new InternalServerException("Unable to update operation action process", e);
        }
    }

    public ProcessDetailDto cancelOperationProcessExecution(String operationId) {
        VitamContext vitamContext = this.buildVitamContext();
        try {
            return this.cancelOperationProcessExecution(vitamContext, operationId);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to cancel operation process execution", e);
        }
    }
}

