/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.fileformat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.common.dto.FileFormatResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamFileFormatCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.fileformat.FileFormatConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileFormatService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileFormatService.class);
    private ObjectMapper objectMapper;
    private FileFormatConverter converter;
    private LogbookService logbookService;
    private VitamFileFormatCommonService vitamFileFormatCommonService;

    @Autowired
    public FileFormatService(ObjectMapper objectMapper, FileFormatConverter converter, LogbookService logbookService, VitamFileFormatCommonService vitamFileFormatCommonService, SecurityService securityService) {
        super(securityService);
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
        this.vitamFileFormatCommonService = vitamFileFormatCommonService;
    }

    public FileFormatDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.info("File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatCommonService.findFileFormatById(vitamContext, identifier);
            FileFormatResponseDto fileFormatResponseDto = (FileFormatResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class);
            if (fileFormatResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((FileFormatModel)fileFormatResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get FileFormat", e);
        }
    }

    public List<FileFormatDto> getAll(VitamContext vitamContext) {
        LOGGER.debug("Get ALL File Formats !");
        try {
            LOGGER.info("All File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatCommonService.findFileFormats(vitamContext, (JsonNode)new Select().getFinalSelect());
            LOGGER.debug("Response: {}", (Object)requestResponse);
            FileFormatResponseDto fileFormatResponseDto = (FileFormatResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class);
            return this.converter.convertVitamsToDtos(fileFormatResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find fileFormats", e);
        }
    }

    public PaginatedValuesDto<FileFormatDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        LOGGER.info("All File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find fileFormats with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        FileFormatResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<FileFormatDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("Formats in page: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private FileFormatResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatCommonService.findFileFormats(vitamContext, query);
            FileFormatResponseDto fileFormatResponseDto = (FileFormatResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class);
            LOGGER.debug("Formats: {}", (Object)fileFormatResponseDto);
            return fileFormatResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find fileFormats", e);
        }
    }

    public Boolean check(VitamContext vitamContext, FileFormatDto accessContractDto) {
        ArrayList<FileFormatDto> fileFormatDtoList = new ArrayList<FileFormatDto>();
        fileFormatDtoList.add(accessContractDto);
        LOGGER.info("File Format Check EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            return !this.vitamFileFormatCommonService.checkAbilityToCreateFileFormatInVitam(this.converter.convertDtosToVitams(fileFormatDtoList), vitamContext);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check fileFormat", (Throwable)e);
        }
    }

    public FileFormatDto create(VitamContext vitamContext, FileFormatDto fileformatDto) {
        LOGGER.debug("Try to create File Format {} {}", (Object)fileformatDto, (Object)vitamContext);
        try {
            LOGGER.info("Create File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatCommonService.create(vitamContext, this.converter.convertDtoToVitam(fileformatDto));
            FileFormatModel fileFormatVitamDto = (FileFormatModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatModel.class);
            return this.converter.convertVitamToDto(fileFormatVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException e) {
            throw new InternalServerException("Unable to create fileFormat", e);
        }
    }

    public FileFormatDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        LOGGER.debug("Try to patch File Format {} {}", partialDto, (Object)vitamContext);
        LOGGER.info("Patch File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        FileFormatDto fileFormat = this.getOne(vitamContext, (String)partialDto.get("puid"));
        partialDto.forEach((key, value) -> {
            if (!"id".equals(key)) {
                try {
                    BeanUtilsBean.getInstance().copyProperty((Object)fileFormat, key, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        });
        FileFormatModel fileFormatVitam = this.converter.convertDtoToVitam(fileFormat);
        try {
            String puid = (String)partialDto.get("puid");
            if (!puid.startsWith("EXTERNAL_")) {
                throw new InternalServerException("Unable to patch fileFormat: Not an external format");
            }
            RequestResponse requestResponse = this.vitamFileFormatCommonService.patchFileFormat(vitamContext, puid, fileFormatVitam);
            FileFormatModel fileFormatVitamDto = (FileFormatModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatModel.class);
            return this.converter.convertVitamToDto(fileFormatVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException e) {
            throw new InternalServerException("Unable to patch fileFormat", e);
        }
    }

    public void delete(VitamContext context, String id) {
        LOGGER.debug("Try to delete File Format {} {}", (Object)id, (Object)context);
        LOGGER.debug("Delete File Format EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        if (!id.startsWith("EXTERNAL_")) {
            throw new InternalServerException("Unable to patch fileFormat: Not an external format");
        }
        try {
            this.vitamFileFormatCommonService.deleteFileFormat(context, id);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException e) {
            throw new InternalServerException("Unable to delete fileFormat", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String identifier) throws VitamClientException {
        LOGGER.debug("findHistoryById for identifier" + identifier);
        LOGGER.debug("File Format History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.logbookService.findEventsByIdentifierAndCollectionNames(identifier, AdminCollections.AGENCIES.getName(), vitamContext).toJsonNode();
    }

    public JsonNode importFileFormats(VitamContext context, String fileName, MultipartFile file) {
        try {
            return this.vitamFileFormatCommonService.importFileFormats(context, fileName, file).toJsonNode();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            LOGGER.error("Unable to file format file {}: {}", (Object)fileName, (Object)e.getMessage());
            throw new InternalServerException("Unable to import file format file " + fileName + " : ", e);
        }
    }

    public FileFormatDto getOne(String identifier) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getOne(vitamContext, identifier);
    }

    public List<FileFormatDto> getAll() {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public FileFormatDto create(FileFormatDto fileFormatDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.create(vitamContext, fileFormatDto);
    }

    public Boolean check(FileFormatDto fileFormatDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.check(vitamContext, fileFormatDto);
    }

    public FileFormatDto patch(Map<String, Object> partialDto) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.patch(vitamContext, partialDto);
    }

    public void delete(String id) {
        VitamContext vitamContext = this.buildVitamContext();
        this.delete(vitamContext, id);
    }

    public LogbookOperationsCommonResponseDto findHistoryById(String identifier) throws VitamClientException {
        VitamContext vitamContext = this.buildVitamContext();
        JsonNode body = this.findHistoryByIdentifier(vitamContext, identifier);
        try {
            return (LogbookOperationsCommonResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsCommonResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public PaginatedValuesDto<FileFormatDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(pageNumber, size, orderBy, direction, vitamContext, criteria);
    }

    public JsonNode importFileFormats(String fileName, MultipartFile file) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.importFileFormats(vitamContext, fileName, file);
    }
}

