/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.accessionregister;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.QueryProjection;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.model.HitsDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterCsv;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailResponseDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterStatsDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryResponseDto;
import fr.gouv.vitamui.referential.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.referential.common.dto.ExportAccessionRegisterResultParam;
import fr.gouv.vitamui.referential.common.service.AccessionRegisterCommonService;
import fr.gouv.vitamui.referential.server.service.AbstractService;
import fr.gouv.vitamui.referential.server.service.accessionregister.AccessRegisterVitamQueryHelper;
import fr.gouv.vitamui.referential.server.service.accessionregister.AccessionRegisterConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AccessionRegisterService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessionRegisterService.class);
    private final ObjectMapper objectMapper;
    private final AgencyCommonService agencyCommonService;
    private final AdminExternalClient adminExternalClient;
    private final AccessionRegisterCommonService accessionRegisterCommonService;

    @Autowired
    public AccessionRegisterService(ObjectMapper objectMapper, AdminExternalClient adminExternalClient, AgencyCommonService agencyCommonService, AccessionRegisterCommonService accessionRegisterCommonService, SecurityService securityService) {
        super(securityService);
        this.objectMapper = objectMapper;
        this.agencyCommonService = agencyCommonService;
        this.adminExternalClient = adminExternalClient;
        this.accessionRegisterCommonService = accessionRegisterCommonService;
    }

    public List<AccessionRegisterSummaryDto> getAll(VitamContext context) {
        try {
            LOGGER.debug("List of Accession Register EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            RequestResponse requestResponse = this.accessionRegisterCommonService.findAccessionRegisterSummary(context);
            AccessionRegisterSummaryResponseDto accessionRegisterSymbolicResponseDto = (AccessionRegisterSummaryResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessionRegisterSummaryResponseDto.class);
            return AccessionRegisterConverter.toSummaryDtos(accessionRegisterSymbolicResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find accessionRegisterSymbolic", e);
        }
    }

    public PaginatedValuesDto<AccessionRegisterDetailDto> getAllPaginated(Optional<String> criteria, Integer pageNumber, Integer pageSize, String orderBy, DirectionDto direction, VitamContext vitamContext) {
        JsonNode query;
        LOGGER.debug("List of Accession Registers EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            AccessionRegisterSearchDto accessionRegisterSearchDto = criteria.isPresent() ? (AccessionRegisterSearchDto)this.objectMapper.readValue(criteria.get(), AccessionRegisterSearchDto.class) : new AccessionRegisterSearchDto();
            query = AccessRegisterVitamQueryHelper.createQueryDSL(accessionRegisterSearchDto, pageNumber, pageSize, orderBy, direction);
        }
        catch (JsonProcessingException | InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get paginated accession registers", ioe);
        }
        AccessionRegisterDetailResponseDto results = this.fetchingAllPaginatedDataFromVitam(vitamContext, query);
        LOGGER.debug("Fetched accession register data : {} ", (Object)results);
        Map<String, String> agenciesMap = this.findAgencies(vitamContext, results);
        HitsDto hits = results.getHits();
        Integer resultSize = 0;
        Integer resultTotal = 0;
        if (hits != null) {
            resultSize = hits.getSize();
            resultTotal = hits.getTotal();
        }
        boolean hasMoreData = pageNumber * pageSize + resultSize < resultTotal;
        List<AccessionRegisterDetailDto> valuesDto = AccessionRegisterConverter.toDetailsDtos(results.getResults());
        valuesDto.forEach(value -> {
            value.setOriginatingAgencyLabel((String)agenciesMap.get(value.getOriginatingAgency()));
            value.setSubmissionAgencyLabel((String)agenciesMap.get(value.getSubmissionAgency()));
        });
        AccessionRegisterStatsDto statsDto = this.buildStatisticData(results);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), pageSize.intValue(), resultTotal.intValue(), hasMoreData, Map.of("stats", statsDto));
    }

    private AccessionRegisterStatsDto buildStatisticData(AccessionRegisterDetailResponseDto resultResponse) {
        AccessionRegisterStatsDto statsDto = new AccessionRegisterStatsDto();
        if (CollectionUtils.isNotEmpty((Collection)resultResponse.getFacetResults())) {
            resultResponse.getFacetResults().stream().forEach(facetResult -> {
                switch (facetResult.getName()) {
                    case "FACETS_TOTAL_OBJECT_GROUPS": {
                        statsDto.setTotalObjectsGroups(facetResult.getSingleValueFacet().getValue().longValue());
                        break;
                    }
                    case "FACETS_TOTAL_OBJECT_SIZE": {
                        statsDto.setObjectSizes(facetResult.getSingleValueFacet().getValue().longValue());
                        break;
                    }
                    case "FACETS_TOTAL_OBJECTS": {
                        statsDto.setTotalObjects(facetResult.getSingleValueFacet().getValue().longValue());
                        break;
                    }
                    case "FACETS_TOTAL_UNITS": {
                        statsDto.setTotalUnits(facetResult.getSingleValueFacet().getValue().longValue());
                    }
                }
            });
        }
        return statsDto;
    }

    public Resource exportToCsvAccessionRegister(AccessionRegisterSearchDto searchQuery, VitamContext vitamContext) {
        LOGGER.debug("Calling exportToCsvAccessionRegister with query {} ", (Object)searchQuery);
        Locale locale = Locale.FRENCH;
        ExportAccessionRegisterResultParam exportSearchResultParam = new ExportAccessionRegisterResultParam(locale);
        return this.exportAccessionRegistersByCriteriaAndParams(searchQuery, exportSearchResultParam, vitamContext);
    }

    private Resource exportAccessionRegistersByCriteriaAndParams(AccessionRegisterSearchDto searchQuery, ExportAccessionRegisterResultParam exportAccessionRegisterResultParam, VitamContext vitamContext) {
        try {
            List<AccessionRegisterCsv> accessionRegisterCsvList = this.exportAccessionRegisterToCsvFile(searchQuery, vitamContext);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8.name());
            String[] headerRecordFr = exportAccessionRegisterResultParam.getHeaders().toArray(new String[exportAccessionRegisterResultParam.getHeaders().size()]);
            SimpleDateFormat dateFormat = new SimpleDateFormat(exportAccessionRegisterResultParam.getPatternDate());
            ICSVWriter csvWriter = new CSVWriterBuilder((Writer)writer).withSeparator(exportAccessionRegisterResultParam.getSeparator()).withQuoteChar('\"').withEscapeChar('\"').withLineEnd("\n").build();
            csvWriter.writeNext(headerRecordFr);
            accessionRegisterCsvList.stream().forEach(accessionRegisterCsv -> {
                String startDateFormated = null;
                if (accessionRegisterCsv.getStartDate() != null) {
                    try {
                        startDateFormated = dateFormat.format(LocalDateUtil.getDate((String)accessionRegisterCsv.getStartDate()));
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing starting date {} ", (Object)accessionRegisterCsv.getStartDate());
                    }
                }
                csvWriter.writeNext(new String[]{accessionRegisterCsv.getOpi(), startDateFormated, accessionRegisterCsv.getOriginatingAgency(), accessionRegisterCsv.getSubmissionAgency(), accessionRegisterCsv.getArchivalAgreement(), accessionRegisterCsv.getAcquisitionInformation(), accessionRegisterCsv.getLegalStatus(), String.valueOf(accessionRegisterCsv.getTotalUnits().getIngested()), String.valueOf(accessionRegisterCsv.getTotalObjectsGroups().getIngested()), String.valueOf(accessionRegisterCsv.getTotalObjects().getIngested()), VitamUIUtils.convertSizeToGigaByte((long)accessionRegisterCsv.getObjectSize().getIngested()), accessionRegisterCsv.getStatus().value()});
            });
            csvWriter.close();
            ((Writer)writer).close();
            return new ByteArrayResource(outputStream.toByteArray());
        }
        catch (IOException ex) {
            throw new BadRequestException("Unable to export csv file ", (Throwable)ex);
        }
    }

    private List<AccessionRegisterCsv> exportAccessionRegisterToCsvFile(AccessionRegisterSearchDto searchQuery, VitamContext vitamContext) {
        try {
            JsonNode query = AccessRegisterVitamQueryHelper.createQueryDSL(searchQuery);
            LOGGER.debug("Final query details: {}", (Object)query.toPrettyString());
            AccessionRegisterDetailResponseDto accessionRegisterDetailResponseDto = this.fetchingAllPaginatedDataFromVitam(vitamContext, query);
            LOGGER.debug("Fetched accession register data : {} ", (Object)accessionRegisterDetailResponseDto);
            List<Object> accessionRegisterList = new ArrayList<AccessionRegisterCsv>();
            if (accessionRegisterDetailResponseDto != null) {
                accessionRegisterList = accessionRegisterDetailResponseDto.getResults().stream().map(this::fillOriginatingAgencyName).collect(Collectors.toList());
            }
            return accessionRegisterList;
        }
        catch (InvalidCreateOperationException e) {
            throw new BadRequestException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        catch (InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get ordered accession registers", (Throwable)ioe);
        }
    }

    private AccessionRegisterCsv fillOriginatingAgencyName(AccessionRegisterDetailModel accessionRegister) {
        AccessionRegisterCsv accessionRegisterCsv = new AccessionRegisterCsv();
        BeanUtils.copyProperties((Object)accessionRegister, (Object)accessionRegisterCsv);
        return accessionRegisterCsv;
    }

    private AccessionRegisterDetailResponseDto fetchingAllPaginatedDataFromVitam(VitamContext vitamContext, JsonNode query) {
        AccessionRegisterDetailResponseDto results;
        try {
            RequestResponse accessionRegisterDetails = this.adminExternalClient.findAccessionRegisterDetails(vitamContext, query);
            results = (AccessionRegisterDetailResponseDto)this.objectMapper.treeToValue((TreeNode)accessionRegisterDetails.toJsonNode(), AccessionRegisterDetailResponseDto.class);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Can't fetch data from VITAM", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Can't process Json Parsing", (Throwable)e);
        }
        return results;
    }

    private Map<String, String> findAgencies(VitamContext vitamContext, AccessionRegisterDetailResponseDto results) {
        List agencies;
        try {
            JsonNode agencyQuery = this.buildAgencyProjectionQuery(results);
            RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, agencyQuery);
            agencies = ((AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class)).getResults();
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error parsing query", (Throwable)e);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Error fetching agencies from vitam", (Throwable)e);
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Invalid Select vitam query", (Throwable)e);
        }
        return agencies.stream().collect(Collectors.toMap(AgenciesModel::getIdentifier, AgenciesModel::getName));
    }

    private JsonNode buildAgencyProjectionQuery(AccessionRegisterDetailResponseDto results) throws InvalidCreateOperationException {
        List<Object> distinctOriginatingAgencies = new ArrayList();
        if (results != null) {
            distinctOriginatingAgencies = results.getResults().stream().map(AccessionRegisterDetailModel::getOriginatingAgency).filter(Objects::nonNull).filter(originatingAgency -> ConcurrentHashMap.newKeySet().add((String)originatingAgency)).collect(Collectors.toList());
            distinctOriginatingAgencies.addAll(results.getResults().stream().map(AccessionRegisterDetailModel::getSubmissionAgency).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        Select select = new Select();
        select.setQuery((Query)QueryHelper.in((String)"Identifier", (String[])distinctOriginatingAgencies.toArray(new String[0])));
        HashMap<String, Integer> projection = new HashMap<String, Integer>();
        projection.put("Identifier", 1);
        projection.put("Name", 1);
        QueryProjection queryProjection = new QueryProjection();
        queryProjection.setFields(projection);
        try {
            select.setProjection(JsonHandler.toJsonNode((Object)queryProjection));
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException("Invalid vitam query", (Throwable)e);
        }
        LOGGER.debug("agencies query: {}", (Object)select.getFinalSelect());
        return select.getFinalSelect();
    }

    public PaginatedValuesDto<AccessionRegisterDetailDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAllPaginated(criteria, page, size, orderBy.orElse(null), direction.orElse(null), vitamContext);
    }

    public List<AccessionRegisterSummaryDto> getAll() {
        VitamContext vitamContext = this.buildVitamContext();
        return this.getAll(vitamContext);
    }

    public Resource exportCsvArchiveUnitsByCriteria(AccessionRegisterSearchDto query) {
        VitamContext vitamContext = this.buildVitamContext();
        return this.exportToCsvAccessionRegister(query, vitamContext);
    }
}

