/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.service.accessionregister;

import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterStatsDto;
import java.util.List;

public class AccessRegisterStatsHelper {
    private AccessRegisterStatsHelper() {
        throw new UnsupportedOperationException("Utility class !");
    }

    public static AccessionRegisterStatsDto fetchStats(List<AccessionRegisterDetailModel> accessionRegisterDetailModels) {
        AccessionRegisterStatsDto statsDto = new AccessionRegisterStatsDto();
        Long objectSizes = accessionRegisterDetailModels.parallelStream().map(AccessionRegisterDetailModel::getObjectSize).map(RegisterValueDetailModel::getIngested).reduce(0L, Long::sum);
        Long totalObjects = accessionRegisterDetailModels.parallelStream().map(AccessionRegisterDetailModel::getTotalObjects).map(RegisterValueDetailModel::getIngested).reduce(0L, Long::sum);
        Long totalUnits = accessionRegisterDetailModels.parallelStream().map(AccessionRegisterDetailModel::getTotalUnits).map(RegisterValueDetailModel::getIngested).reduce(0L, Long::sum);
        Long totalObjectsGroups = accessionRegisterDetailModels.parallelStream().map(AccessionRegisterDetailModel::getTotalObjectsGroups).map(RegisterValueDetailModel::getIngested).reduce(0L, Long::sum);
        statsDto.setObjectSizes(objectSizes.longValue());
        statsDto.setTotalObjects(totalObjects.longValue());
        statsDto.setTotalUnits(totalUnits.longValue());
        statsDto.setTotalObjectsGroups(totalObjectsGroups.longValue());
        return statsDto;
    }
}

