/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.referential.server.service.unit.UnitService;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/units"})
public class UnitController {
    @Autowired
    private UnitService unitExternalService;

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_UNITS"})
    public VitamUISearchResponseDto searchById(@PathVariable(value="id") String id) throws InvalidParseOperationException, VitamClientException {
        ParameterChecker.checkParameter((String)"The archive unit id is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.unitExternalService.findUnitById(id);
    }

    @PostMapping(value={"/dsl", "/dsl/{id}"})
    @Secured(value={"ROLE_GET_UNITS"})
    public JsonNode searchByDsl(@PathVariable Optional<String> id, @RequestBody JsonNode dsl) throws VitamClientException {
        ParameterChecker.checkParameter((String)"The dsl query is mandatory : ", (Object[])new Object[]{dsl});
        SanityChecker.sanitizeJson((JsonNode)dsl);
        return this.unitExternalService.findUnitByDsl(id, dsl);
    }

    @PostMapping(value={"/{id}/objects"})
    @Secured(value={"ROLE_GET_UNITS"})
    public JsonNode findObjectMetadataById(@PathVariable String id, @RequestBody JsonNode dsl) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The dsl query is mandatory : ", (Object[])new Object[]{dsl});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeJson((JsonNode)dsl);
        return this.unitExternalService.findObjectMetadataById(id, dsl);
    }

    @Secured(value={"ROLE_GET_FILLING_PLAN_ACCESS"})
    @GetMapping(value={"/filingplan"})
    public VitamUISearchResponseDto getFilingAndHoldingUnits() throws VitamClientException, JsonProcessingException {
        return this.unitExternalService.getFilingAndHoldingUnits();
    }

    @Generated
    public UnitService getUnitExternalService() {
        return this.unitExternalService;
    }

    @Generated
    public void setUnitExternalService(UnitService unitExternalService) {
        this.unitExternalService = unitExternalService;
    }
}

