/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileDto;
import fr.gouv.vitamui.referential.server.service.securityprofile.SecurityProfileService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/security-profile"})
public class SecurityProfileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityProfileController.class);
    @Autowired
    private SecurityProfileService securityProfileService;

    @GetMapping
    @Secured(value={"ROLE_GET_SECURITY_PROFILES"})
    public Collection<SecurityProfileDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.securityProfileService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_SECURITY_PROFILES"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<SecurityProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.securityProfileService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_SECURITY_PROFILES"})
    @GetMapping(path={"/{identifier:.+}"})
    public SecurityProfileDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get security profile identifier={}");
        return this.securityProfileService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_SECURITY_PROFILES"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody SecurityProfileDto securityProfileDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)securityProfileDto);
        LOGGER.debug("check exist accessContract={}", (Object)securityProfileDto);
        boolean exist = this.securityProfileService.check(securityProfileDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_SECURITY_PROFILES"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public SecurityProfileDto create(@Valid @RequestBody SecurityProfileDto securityProfileDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)securityProfileDto);
        LOGGER.debug("Create {}", (Object)securityProfileDto);
        return this.securityProfileService.create(securityProfileDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_SECURITY_PROFILES"})
    public SecurityProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.securityProfileService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_SECURITY_PROFILES"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        return this.securityProfileService.findHistoryById(id);
    }

    @Secured(value={"ROLE_DELETE_SECURITY_PROFILES"})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Event Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete securityProfile with id :{}", (Object)id);
        this.securityProfileService.delete(id);
    }

    @Generated
    public SecurityProfileService getSecurityProfileService() {
        return this.securityProfileService;
    }

    @Generated
    public void setSecurityProfileService(SecurityProfileService securityProfileService) {
        this.securityProfileService = securityProfileService;
    }
}

