/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.referential.server.service.schema.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/schemas-unit"})
public class SchemaUnitController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUnitController.class);
    private final SchemaService schemaService;
    private final SecurityService securityService;

    @Autowired
    public SchemaUnitController(SchemaService schemaService, SecurityService securityService) {
        this.schemaService = schemaService;
        this.securityService = securityService;
    }

    @Secured(value={"ROLE_IMPORT_SCHEMAS"})
    @PostMapping(value={"/import"})
    public ResponseEntity<Void> importUnitSchemas(@RequestParam(value="file") MultipartFile file) {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("The file cannot be null or empty.");
        }
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        SanityChecker.isValidFileName((String)file.getOriginalFilename());
        return this.schemaService.importUnitSchema(file);
    }
}

