/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.referential.common.dto.SchemaDto;
import fr.gouv.vitamui.referential.common.exception.NoCollectionException;
import fr.gouv.vitamui.referential.common.model.Collection;
import fr.gouv.vitamui.referential.server.service.schema.SchemaService;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schemas"})
public class SchemaController {
    private final SchemaService schemaService;

    @Autowired
    public SchemaController(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @GetMapping
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_GET_SCHEMAS"})
    public ResponseEntity<List<SchemaDto>> getSchemas(@RequestParam Set<Collection> collections) throws NoCollectionException {
        if (CollectionUtils.isEmpty(collections)) {
            throw new NoCollectionException();
        }
        return ResponseEntity.ok(this.schemaService.getSchemas(collections));
    }

    @DeleteMapping
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_DELETE_SCHEMAS"})
    public ResponseEntity<String> deleteSchemas(@RequestBody List<String> paths) throws AccessExternalClientException, InvalidParseOperationException {
        return ResponseEntity.ok((Object)this.schemaService.deleteSchemas(paths));
    }

    @GetMapping(value={"/archive-unit-profile/{id}"})
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_GET_SCHEMAS"})
    public ResponseEntity<SchemaDto> getArchiveUnitProfileSchema(@PathVariable @NotNull String id) throws VitamClientException {
        return ResponseEntity.ok((Object)this.schemaService.getArchiveUnitProfileSchema(id));
    }
}

