/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.referential.server.service.rule.RuleService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/rules"})
public class RuleController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleController.class);
    private RuleService ruleService;
    private static final String IDENTIFIER_MANDATORY_MESSAGE = "The Identifier is a mandatory parameter: ";

    @Autowired
    public RuleController(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_RULES"})
    public Collection<RuleDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all rules criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.ruleService.getAll();
    }

    @Secured(value={"ROLE_GET_RULES"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<RuleDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.ruleService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_RULES"})
    @GetMapping(path={"/{identifier:.+}"})
    public RuleDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get rule identifier={}");
        return this.ruleService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_RULES"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody RuleDto ruleDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ruleDto);
        LOGGER.debug("check exist accessContract={}", (Object)ruleDto);
        boolean exist = this.ruleService.check(ruleDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_RULES"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public ResponseEntity<Void> create(@Valid @RequestBody RuleDto ruleDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (Object[])new Object[]{ruleDto});
        SanityChecker.sanitizeCriteria((Object)ruleDto);
        LOGGER.debug("Create {}", (Object)ruleDto);
        return RestUtils.buildBooleanResponse((boolean)this.ruleService.createRule(ruleDto));
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_CREATE_RULES"})
    public ResponseEntity<Void> patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return RestUtils.buildBooleanResponse((boolean)this.ruleService.patchRule(partialDto));
    }

    @Secured(value={"ROLE_GET_RULES"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        return this.ruleService.findHistoryById(id);
    }

    @Secured(value={"ROLE_DELETE_RULES"})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete rule with id :{}", (Object)id);
        return RestUtils.buildBooleanResponse((boolean)this.ruleService.deleteRule(id));
    }

    @Secured(value={"ROLE_GET_RULES"})
    @GetMapping(value={"/export"})
    public ResponseEntity<Resource> export() {
        return this.ruleService.export();
    }

    @Secured(value={"ROLE_IMPORT_RULES"})
    @PostMapping(value={"/import"})
    public JsonNode importRules(@RequestParam(value="file") MultipartFile file) {
        LOGGER.debug("Import referential file {}", (Object)(file != null ? file.getOriginalFilename() : null));
        if (file == null) {
            throw new BadRequestException("No file to check .");
        }
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        SanityChecker.isValidFileName((String)file.getOriginalFilename());
        return this.ruleService.importRules(file.getOriginalFilename(), file);
    }

    @Generated
    public RuleService getRuleService() {
        return this.ruleService;
    }

    @Generated
    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }
}

