/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.server.service.ingestcontract.IngestContractService;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/ingestcontract"})
public class IngestContractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestContractController.class);
    @Autowired
    private IngestContractService ingestContractService;

    @GetMapping
    @Secured(value={"ROLE_GET_INGEST_CONTRACTS"})
    public Collection<IngestContractDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.ingestContractService.getAll();
    }

    @Secured(value={"ROLE_GET_INGEST_CONTRACTS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<IngestContractDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.ingestContractService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_INGEST_CONTRACTS"})
    @GetMapping(path={"/{identifier:.+}"})
    public IngestContractDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get ingestcontract  identifier={}", (Object)identifier);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        return this.ingestContractService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_INGEST_CONTRACTS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody IngestContractDto ingestContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        SanityChecker.sanitizeCriteria((Object)ingestContractDto);
        LOGGER.debug("check exist ingestContract={}", (Object)ingestContractDto);
        ingestContractDto.setTenant(tenant);
        boolean exist = this.ingestContractService.check(ingestContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_INGEST_CONTRACTS"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public IngestContractDto create(@Valid @RequestBody IngestContractDto ingestContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        SanityChecker.sanitizeCriteria((Object)ingestContractDto);
        LOGGER.debug("Create {}", (Object)ingestContractDto);
        ingestContractDto.setTenant(tenant);
        return this.ingestContractService.create(ingestContractDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_INGEST_CONTRACTS"})
    public IngestContractDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.ingestContractService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_INGEST_CONTRACTS"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for ingestContract with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.ingestContractService.findHistoryById(id);
    }

    @Secured(value={"ROLE_CREATE_INGEST_CONTRACTS"})
    @PostMapping(value={"/import"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> importIngestContracts(@RequestParam(value="file") MultipartFile file) {
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter : ", (String[])new String[]{file.getOriginalFilename()});
        SanityChecker.isValidFileName((String)file.getOriginalFilename());
        LOGGER.debug("Import ingest contracts file {}", (Object)file.getOriginalFilename());
        return this.ingestContractService.importIngestContracts(file);
    }

    @ApiOperation(value="Export ingest contracts to a csv file")
    @GetMapping(path={"/export-csv"})
    @Secured(value={"ROLE_GET_INGEST_CONTRACTS"})
    public ResponseEntity<Resource> exportIngestContracts() {
        LOGGER.debug("export all ingest contracts to csv file");
        return this.ingestContractService.exportIngestContracts();
    }

    @Generated
    public IngestContractService getIngestContractService() {
        return this.ingestContractService;
    }

    @Generated
    public void setIngestContractService(IngestContractService ingestContractService) {
        this.ingestContractService = ingestContractService;
    }
}

