/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.server.service.fileformat.FileFormatService;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/fileformats"})
public class FileFormatController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileFormatController.class);
    @Autowired
    private FileFormatService fileFormatService;

    @GetMapping
    @Secured(value={"ROLE_GET_FILE_FORMATS"})
    public Collection<FileFormatDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.fileFormatService.getAll();
    }

    @Secured(value={"ROLE_GET_FILE_FORMATS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<FileFormatDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.fileFormatService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_FILE_FORMATS"})
    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    public Object getByIdOrHistory(HttpServletRequest request) throws UnsupportedEncodingException, InvalidParseOperationException, VitamClientException {
        LOGGER.debug("getByIdOrHistory ");
        String requestURL = request.getRequestURL().toString();
        String path = StringUtils.substringAfter((String)requestURL, (String)"/referential/v1/fileformats/");
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)"/history")) {
            return this.findHistoryById(StringUtils.substringBefore((String)path, (String)"/history"));
        }
        return this.getOne(StringUtils.removeEndIgnoreCase((String)path, (String)"/"));
    }

    private FileFormatDto getOne(@PathVariable(value="identifier") String identifier) {
        LOGGER.debug("get file format identifier={}");
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{identifier});
        return this.fileFormatService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_FILE_FORMATS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody FileFormatDto fileFormatDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        SanityChecker.sanitizeCriteria((Object)fileFormatDto);
        LOGGER.debug("check exist accessContract={}", (Object)fileFormatDto);
        ApiUtils.checkValidity((Object)fileFormatDto);
        boolean exist = this.fileFormatService.check(fileFormatDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_FILE_FORMATS"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public FileFormatDto create(@Valid @RequestBody FileFormatDto fileFormatDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)fileFormatDto);
        LOGGER.debug("Create {}", (Object)fileFormatDto);
        ApiUtils.checkValidity((Object)fileFormatDto);
        return this.fileFormatService.create(fileFormatDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_FILE_FORMATS"})
    public FileFormatDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.fileFormatService.patch(partialDto);
    }

    private LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.fileFormatService.findHistoryById(id);
    }

    @Secured(value={"ROLE_DELETE_FILE_FORMATS"})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete fileFormat with id :{}", (Object)id);
        this.fileFormatService.delete(id);
    }

    @Secured(value={"ROLE_IMPORT_FILE_FORMATS"})
    @PostMapping(value={"/import"})
    public JsonNode importFileFormats(@RequestParam(value="file") MultipartFile file) {
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter : ", (String[])new String[]{file.getOriginalFilename()});
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        SanityChecker.isValidFileName((String)file.getOriginalFilename());
        LOGGER.debug("Import file format file {}", (Object)file.getOriginalFilename());
        return this.fileFormatService.importFileFormats(file.getOriginalFilename(), file);
    }

    @Generated
    public FileFormatService getFileFormatService() {
        return this.fileFormatService;
    }

    @Generated
    public void setFileFormatService(FileFormatService fileFormatService) {
        this.fileFormatService = fileFormatService;
    }
}

