/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.referential.server.service.accesscontract.AccessContractService;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/accesscontracts"})
public class AccessContractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessContractController.class);
    @Autowired
    private AccessContractService accessContractService;

    @GetMapping
    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    public Collection<AccessContractDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.accessContractService.getAll();
    }

    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<AccessContractDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.accessContractService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    @GetMapping(path={"/{identifier:.+}"})
    public AccessContractDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("getAccessContract identifier={}");
        return this.accessContractService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody AccessContractDto accessContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)accessContractDto);
        LOGGER.debug("check exist accessContract={}", (Object)accessContractDto);
        boolean exist = this.accessContractService.check(accessContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_ACCESS_CONTRACTS"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public AccessContractDto create(@Valid @RequestBody AccessContractDto accessContractDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)accessContractDto);
        LOGGER.debug("Create {}", (Object)accessContractDto);
        return this.accessContractService.create(accessContractDto);
    }

    @Secured(value={"ROLE_UPDATE_ACCESS_CONTRACTS"})
    @PatchMapping(value={"/{id}"})
    public AccessContractDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.accessContractService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        return this.accessContractService.findHistoryById(id);
    }

    @ApiOperation(value="Export access contract to a csv file")
    @GetMapping(path={"/export-csv"})
    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    public ResponseEntity<Resource> exportAccessContracts() {
        LOGGER.debug("export all access contract to csv file");
        return this.accessContractService.exportAccessContracts();
    }

    @Secured(value={"ROLE_CREATE_ACCESS_CONTRACTS"})
    @PostMapping(value={"/import"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> importAccessContracts(@RequestParam(value="file") MultipartFile file) {
        SanityChecker.isValidFileName((String)file.getOriginalFilename());
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter : ", (String[])new String[]{file.getOriginalFilename()});
        LOGGER.debug("Import access contracts file {}", (Object)file.getOriginalFilename());
        return this.accessContractService.importAccessContracts(file);
    }

    @Generated
    public AccessContractService getAccessContractService() {
        return this.accessContractService;
    }

    @Generated
    public void setAccessContractService(AccessContractService accessContractService) {
        this.accessContractService = accessContractService;
    }
}

