/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.commons.vitam.api.access.UnitCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import fr.gouv.vitamui.commons.vitam.api.administration.VitamOperationCommonService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.iam.client.ApplicationRestClient;
import fr.gouv.vitamui.iam.client.ExternalParametersRestClient;
import fr.gouv.vitamui.iam.client.IamRestClientFactory;
import fr.gouv.vitamui.iam.client.UserRestClient;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.referential.common.service.AccessionRegisterCommonService;
import fr.gouv.vitamui.referential.common.service.ImportSchemaCommonService;
import fr.gouv.vitamui.referential.common.service.IngestContractCommonService;
import fr.gouv.vitamui.referential.common.service.OntologyCommonService;
import fr.gouv.vitamui.referential.common.service.OperationCommonService;
import fr.gouv.vitamui.referential.common.service.VitamAgencyCommonService;
import fr.gouv.vitamui.referential.common.service.VitamArchivalProfileUnitCommonService;
import fr.gouv.vitamui.referential.common.service.VitamBatchReportCommonService;
import fr.gouv.vitamui.referential.common.service.VitamContextCommonService;
import fr.gouv.vitamui.referential.common.service.VitamFileFormatCommonService;
import fr.gouv.vitamui.referential.common.service.VitamRuleCommonService;
import fr.gouv.vitamui.referential.common.service.VitamSecurityProfileCommonService;
import fr.gouv.vitamui.referential.common.service.VitamUIAccessContractCommonService;
import fr.gouv.vitamui.referential.common.service.VitamUIManagementContractCommonService;
import fr.gouv.vitamui.referential.server.config.ApiReferentialApplicationProperties;
import fr.gouv.vitamui.referential.server.config.ConverterConfig;
import fr.gouv.vitamui.referential.server.security.WebSecurityConfig;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.MultipartFilter;

@Configuration
@Import(value={RestExceptionHandler.class, SwaggerConfiguration.class, HttpMessageConvertersAutoConfiguration.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamAdministrationConfig.class, ConverterConfig.class})
public class ApiReferentialServerConfig
extends AbstractContextConfiguration {
    @Bean
    public MultipartResolver multipartResolver() {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver();
        return commonsMultipartResolver;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        MultipartFilter multipartFilter = new MultipartFilter();
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)multipartFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.addInitParameter("multipartResolverBeanName", "commonsMultipartResolver");
        return filterRegistrationBean;
    }

    @Bean
    public SecurityRestClientFactory securityRestClientFactory(ApiReferentialApplicationProperties apiReferentialApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityRestClientFactory(apiReferentialApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextCrudRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public SecurityService securityService() {
        return new SecurityService();
    }

    @Bean
    public VitamUIAccessContractCommonService vitamUIAccessContractCommonService(AdminExternalClient adminExternalClient) {
        return new VitamUIAccessContractCommonService(adminExternalClient);
    }

    @Bean
    public AccessionRegisterCommonService accessionRegisterCommonService(AdminExternalClient adminExternalClient) {
        return new AccessionRegisterCommonService(adminExternalClient);
    }

    @Bean
    public VitamAgencyCommonService vitamAgencyCommonService(AdminExternalClient adminClient, AgencyCommonService agencyCommonService, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamAgencyCommonService(adminClient, agencyCommonService, objectMapper, accessClient);
    }

    @Bean
    public VitamArchivalProfileUnitCommonService vitamArchivalProfileUnitCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamArchivalProfileUnitCommonService(adminClient, objectMapper, accessClient);
    }

    @Bean
    public VitamContextCommonService vitamContextCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper) {
        return new VitamContextCommonService(adminClient, objectMapper);
    }

    @Bean
    public VitamFileFormatCommonService vitamFileFormatCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamFileFormatCommonService(adminClient, objectMapper, accessClient);
    }

    @Bean
    public VitamUIManagementContractCommonService vitamUIManagementContractCommonService(AdminExternalClient adminClient) {
        return new VitamUIManagementContractCommonService(adminClient);
    }

    @Bean
    public OntologyCommonService ontologyCommonService(AdminExternalClient adminExternalClient) {
        return new OntologyCommonService(adminExternalClient);
    }

    @Bean
    public OperationCommonService operationCommonService(AdminExternalClient adminExternalClient) {
        return new OperationCommonService(adminExternalClient);
    }

    @Bean
    public VitamRuleCommonService vitamRuleCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper, AccessExternalClient accessClient) {
        return new VitamRuleCommonService(adminClient, objectMapper, accessClient);
    }

    @Bean
    public VitamSecurityProfileCommonService vitamSecurityProfileCommonService(AdminExternalClient adminClient, ObjectMapper objectMapper) {
        return new VitamSecurityProfileCommonService(adminClient, objectMapper);
    }

    @Bean
    public IngestContractCommonService ingestContractCommonService(AdminExternalClient adminExternalClient) {
        return new IngestContractCommonService(adminExternalClient);
    }

    @Bean
    public VitamBatchReportCommonService vitamBatchReportCommonService(AdminExternalClient adminExternalClient) {
        return new VitamBatchReportCommonService(adminExternalClient);
    }

    @Bean
    public IamRestClientFactory iamRestClientFactory(ApiReferentialApplicationProperties apiReferentialApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamRestClientFactory(apiReferentialApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public ApplicationRestClient applicationRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getApplicationExternalRestClient();
    }

    @Bean
    public UnitCommonService unitCommonService(AccessExternalClient client) {
        return new UnitCommonService(client);
    }

    @Bean
    public VitamOperationCommonService vitamOperationCommonService(AdminExternalClient adminExternalClient) {
        return new VitamOperationCommonService(adminExternalClient);
    }

    @Bean
    public ExternalParametersRestClient externalParametersRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getExternalParametersExternalRestClient();
    }

    @Bean
    public UserRestClient userRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getUserExternalRestClient();
    }

    @Bean
    public UserAuthenticationService authentificationService(UserRestClient userRestClient) {
        return new IamClientUserAuthenticationService(userRestClient);
    }

    @Bean
    public InternalApiAuthenticationProvider internalApiAuthenticationProvider(UserAuthenticationService userAuthenticationService) {
        return new InternalApiAuthenticationProvider(userAuthenticationService);
    }

    @Bean
    public ExternalApiAuthenticationProvider externalApiAuthenticationProvider(SecurityRestClientFactory securityRestClientFactory, UserAuthenticationService userAuthenticationService) {
        return new ExternalApiAuthenticationProvider(securityRestClientFactory.getContextRestClient(), userAuthenticationService);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(InternalApiAuthenticationProvider internalApiAuthenticationProvider, ExternalApiAuthenticationProvider externalApiAuthenticationProvider) {
        return new ApiAuthenticationProvider(internalApiAuthenticationProvider, externalApiAuthenticationProvider);
    }

    @Bean
    public ImportSchemaCommonService importSchemaCommonService(AdminExternalClient adminExternalClient) {
        return new ImportSchemaCommonService(adminExternalClient);
    }
}

