/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchExternalParametersService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchThresholdService;
import fr.gouv.vitamui.commons.vitam.api.access.TransferAcknowledgmentService;
import fr.gouv.vitamui.commons.vitam.api.access.TransferRequestService;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TransferVitamOperationsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferVitamOperationsService.class);
    public static final String OPERATION_IDENTIFIER = "itemId";
    private final TransferAcknowledgmentService transferAcknowledgmentService;
    private final TransferRequestService transferRequestService;
    private final ArchiveSearchService archiveSearchService;
    private final ArchiveSearchThresholdService archiveSearchThresholdService;
    private final ArchiveSearchExternalParametersService archiveSearchExternalParametersService;

    public TransferVitamOperationsService(TransferAcknowledgmentService transferAcknowledgmentService, @Lazy ArchiveSearchService archiveSearchService, TransferRequestService transferRequestService, ArchiveSearchThresholdService archiveSearchThresholdService, ArchiveSearchExternalParametersService archiveSearchExternalParametersService) {
        this.transferAcknowledgmentService = transferAcknowledgmentService;
        this.archiveSearchService = archiveSearchService;
        this.transferRequestService = transferRequestService;
        this.archiveSearchThresholdService = archiveSearchThresholdService;
        this.archiveSearchExternalParametersService = archiveSearchExternalParametersService;
    }

    private JsonNode sendTransferRequest(VitamContext vitamContext, TransferRequest transferRequest) throws VitamClientException {
        RequestResponse response = this.transferRequestService.transferRequest(vitamContext, transferRequest);
        return response.toJsonNode();
    }

    private TransferRequest prepareTransferRequestBody(TransferRequestDto transferRequestDto, JsonNode dslQuery) {
        TransferRequest transferRequest = new TransferRequest();
        if (transferRequestDto != null) {
            DataObjectVersions dataObjectVersions = new DataObjectVersions();
            dataObjectVersions.setDataObjectVersionsPatterns(transferRequestDto.getDataObjectVersionsPatterns());
            transferRequest.setTransferWithLogBookLFC(transferRequestDto.isLifeCycleLogs());
            transferRequest.setTransferWithoutObjects(transferRequestDto.isWithoutObjects());
            transferRequest.setDslRequest(dslQuery);
            transferRequest.setDataObjectVersionToExport(dataObjectVersions);
            transferRequest.setTransferRequestParameters(transferRequestDto.getTransferRequestParameters());
            transferRequest.setSedaVersion(transferRequestDto.getSedaVersion());
        }
        return transferRequest;
    }

    public String transferRequest(TransferRequestDto transferRequestDto) throws VitamClientException {
        LOGGER.debug("Transfer request: {} ", (Object)transferRequestDto.toString());
        VitamContext vitamContext = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        thresholdOpt.ifPresent(aLong -> transferRequestDto.getSearchCriteria().setThreshold(aLong));
        JsonNode dslQuery = this.archiveSearchService.prepareDslQuery(transferRequestDto.getSearchCriteria(), vitamContext);
        LOGGER.debug("Transfer request final DSL query: {} ", (Object)dslQuery);
        TransferRequest transferRequest = this.prepareTransferRequestBody(transferRequestDto, dslQuery);
        JsonNode response = this.sendTransferRequest(vitamContext, transferRequest);
        return response.findValue(OPERATION_IDENTIFIER).textValue();
    }

    public String transferAcknowledgment(InputStream atrInputStream) throws VitamClientException {
        LOGGER.debug("Transfer Acknowledgment Operation");
        VitamContext vitamContext = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        JsonNode transferAcknowledgmentResponse = this.transferAcknowledgmentService.transferAcknowledgment(vitamContext, atrInputStream).toJsonNode();
        return transferAcknowledgmentResponse.findValue(OPERATION_IDENTIFIER).textValue();
    }
}

