/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import fr.gouv.vitamui.iam.client.ExternalParametersRestClient;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchThresholdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveSearchThresholdService.class);
    public static final String PARAM_BULK_OPERATIONS_THRESHOLD_NAME = "PARAM_BULK_OPERATIONS_THRESHOLD";
    private final ExternalParametersRestClient externalParametersRestClient;
    private final SecurityService securityService;

    @Autowired
    public ArchiveSearchThresholdService(ExternalParametersRestClient externalParametersRestClient, SecurityService securityService) {
        this.externalParametersRestClient = externalParametersRestClient;
        this.securityService = securityService;
    }

    public Optional<Long> retrieveProfilThresholds() {
        Map.Entry parameterThreshold;
        Optional<Long> thresholdOpt = Optional.empty();
        Map myExternalParameter = this.externalParametersRestClient.getMyExternalParameters(this.securityService.getHttpContext());
        if (myExternalParameter != null && !CollectionUtils.isEmpty(myExternalParameter.entrySet()) && (parameterThreshold = (Map.Entry)myExternalParameter.entrySet().stream().filter(parameter -> PARAM_BULK_OPERATIONS_THRESHOLD_NAME.equals(parameter.getKey())).findFirst().orElse(null)) != null && parameterThreshold.getValue() != null) {
            try {
                Long thresholdValue = Long.valueOf((String)parameterThreshold.getValue());
                thresholdOpt = Optional.of(thresholdValue);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("external parameter of bulk threshold contains wrong integer value {}, it will not be used ", parameterThreshold.getValue());
                throw new IllegalArgumentException("external parameter of bulk threshold contains wrong integer value " + (String)parameterThreshold.getValue() + ", it will not be used ");
            }
        }
        return thresholdOpt;
    }
}

