/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchExternalParametersService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchThresholdService;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.vitam.api.access.EliminationService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ArchiveSearchEliminationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveSearchEliminationService.class);
    private final EliminationService eliminationService;
    private final ArchiveSearchService archiveSearchService;
    private final ArchiveSearchThresholdService archiveSearchThresholdService;
    private final ArchiveSearchExternalParametersService archiveSearchExternalParametersService;
    private final ObjectMapper objectMapper;

    @Autowired
    public ArchiveSearchEliminationService(@Lazy ArchiveSearchService archiveSearchService, EliminationService eliminationService, ArchiveSearchThresholdService archiveSearchThresholdService, ArchiveSearchExternalParametersService archiveSearchExternalParametersService, ObjectMapper objectMapper) {
        this.eliminationService = eliminationService;
        this.archiveSearchService = archiveSearchService;
        this.archiveSearchThresholdService = archiveSearchThresholdService;
        this.archiveSearchExternalParametersService = archiveSearchExternalParametersService;
        this.objectMapper = objectMapper;
    }

    public JsonNode startEliminationAction(SearchCriteriaDto searchQuery) throws VitamClientException {
        LOGGER.debug("Elimination action by criteria {} ", (Object)searchQuery.toString());
        VitamContext vitamContext = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        JsonNode dslQuery = this.archiveSearchService.prepareDslQuery(searchQuery, vitamContext);
        EliminationRequestBody eliminationRequestBody = null;
        eliminationRequestBody = this.getEliminationRequestBody(dslQuery, searchQuery.getThreshold());
        LOGGER.debug("Elimination action final query {} ", (Object)JsonHandler.prettyPrint((Object)eliminationRequestBody.getDslRequest()));
        RequestResponse jsonNodeRequestResponse = this.eliminationService.startEliminationAction(vitamContext, eliminationRequestBody);
        return jsonNodeRequestResponse.toJsonNode();
    }

    public EliminationRequestBody getEliminationRequestBody(JsonNode updateSet, Long threshold) {
        ObjectNode query = JsonHandler.createObjectNode();
        query.set(BuilderToken.GLOBAL.ROOTS.exactToken(), updateSet.get(BuilderToken.GLOBAL.ROOTS.exactToken()));
        query.set(BuilderToken.GLOBAL.QUERY.exactToken(), updateSet.get(BuilderToken.GLOBAL.QUERY.exactToken()));
        if (threshold != null) {
            query.set(BuilderToken.GLOBAL.THRESOLD.exactToken(), (JsonNode)this.objectMapper.convertValue((Object)threshold, JsonNode.class));
        }
        EliminationRequestBody requestBody = new EliminationRequestBody();
        requestBody.setDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        requestBody.setDslRequest((JsonNode)query);
        return requestBody;
    }

    public JsonNode startEliminationAnalysis(SearchCriteriaDto searchQuery) throws VitamClientException {
        LOGGER.debug("Elimination analysis by criteria {} ", (Object)searchQuery.toString());
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        thresholdOpt.ifPresent(arg_0 -> ((SearchCriteriaDto)searchQuery).setThreshold(arg_0));
        VitamContext vitamContext = this.archiveSearchExternalParametersService.buildVitamContextFromExternalParam();
        JsonNode dslQuery = this.archiveSearchService.prepareDslQuery(searchQuery, vitamContext);
        EliminationRequestBody eliminationRequestBody = this.getEliminationRequestBody(dslQuery, searchQuery.getThreshold());
        LOGGER.debug("Elimination analysis final query {} ", (Object)JsonHandler.prettyPrint((Object)eliminationRequestBody.getDslRequest()));
        RequestResponse jsonNodeRequestResponse = this.eliminationService.startEliminationAnalysis(vitamContext, eliminationRequestBody);
        return jsonNodeRequestResponse.toJsonNode();
    }
}

