/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.archives.search.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.archives.search.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.dtos.CriteriaValue;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaEltDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.utils.ArchiveSearchConsts;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchAgenciesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveSearchAgenciesService.class);
    private final ObjectMapper objectMapper;
    private final AgencyCommonService agencyCommonService;

    @Autowired
    public ArchiveSearchAgenciesService(ObjectMapper objectMapper, AgencyCommonService agencyCommonService) {
        this.objectMapper = objectMapper;
        this.agencyCommonService = agencyCommonService;
    }

    public void mapAgenciesNameToCodes(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("calling mapAgenciesNameToCodes  {} ", (Object)searchQuery.toString());
        HashSet<String> agencyOriginNamesCriteria = new HashSet<String>();
        searchQuery.getCriteriaList().stream().filter(criteriaElt -> criteriaElt.getCriteria().equals("SP_LABEL")).forEach(criteriaElt -> agencyOriginNamesCriteria.addAll(criteriaElt.getValues().stream().map(CriteriaValue::getValue).collect(Collectors.toList())));
        if (!agencyOriginNamesCriteria.isEmpty()) {
            LOGGER.debug(" trying to mapping agencies labels {} ", (Object)((Object)agencyOriginNamesCriteria).toString());
            List<AgencyModelDto> agenciesOrigins = this.findOriginAgenciesByNames(vitamContext, agencyOriginNamesCriteria);
            if (!CollectionUtils.isEmpty(agenciesOrigins)) {
                this.mapAgenciesNamesToAgenciesCodesInCriteria(searchQuery, agenciesOrigins);
            }
        }
    }

    private void mapAgenciesNamesToAgenciesCodesInCriteria(SearchCriteriaDto searchQuery, List<AgencyModelDto> actualAgencies) {
        if (searchQuery != null && searchQuery.getCriteriaList() != null && !searchQuery.getCriteriaList().isEmpty()) {
            List mergedCriteriaList = searchQuery.getCriteriaList().stream().filter(criteria -> !"SP_CODE".equals(criteria.getCriteria()) && !"SP_LABEL".equals(criteria.getCriteria())).collect(Collectors.toList());
            List filteredAgenciesId = actualAgencies.stream().map(AgencyModelDto::getIdentifier).collect(Collectors.toList());
            List<SearchCriteriaEltDto> idCriteriaList = searchQuery.getCriteriaList().stream().filter(criteria -> "SP_CODE".equals(criteria.getCriteria())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(idCriteriaList)) {
                SearchCriteriaEltDto idCriteria = new SearchCriteriaEltDto();
                idCriteria.setCriteria("SP_CODE");
                idCriteria.setValues(filteredAgenciesId.stream().map(CriteriaValue::new).collect(Collectors.toList()));
                idCriteria.setOperator(ArchiveSearchConsts.CriteriaOperators.EQ.name());
                idCriteria.setCategory(ArchiveSearchConsts.CriteriaCategory.FIELDS);
                mergedCriteriaList.add(idCriteria);
            } else {
                idCriteriaList.forEach(criteria -> {
                    if (!CollectionUtils.isEmpty((Collection)criteria.getValues())) {
                        filteredAgenciesId.addAll(criteria.getValues().stream().map(CriteriaValue::getValue).collect(Collectors.toList()));
                    }
                    criteria.setValues(filteredAgenciesId.stream().map(CriteriaValue::new).collect(Collectors.toList()));
                    mergedCriteriaList.add(criteria);
                });
            }
            searchQuery.setCriteriaList(mergedCriteriaList);
        }
    }

    public List<AgencyModelDto> findOriginAgenciesByCriteria(VitamContext vitamContext, String field, List<String> originAgenciesCodes) throws VitamClientException {
        List<Object> agencies = new ArrayList<AgencyModelDto>();
        if (originAgenciesCodes != null && !originAgenciesCodes.isEmpty()) {
            LOGGER.debug("Finding originating agencies by field {}  values {} ", (Object)field, originAgenciesCodes);
            HashMap<String, List<String>> searchCriteriaMap = new HashMap<String, List<String>>();
            searchCriteriaMap.put(field, originAgenciesCodes);
            try {
                JsonNode queryOriginAgencies = VitamQueryHelper.createQueryDSL(searchCriteriaMap, Optional.empty(), Optional.empty());
                RequestResponse requestResponse = this.agencyCommonService.findAgencies(vitamContext, queryOriginAgencies);
                agencies = ((AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class)).getResults();
            }
            catch (InvalidCreateOperationException e) {
                throw new VitamClientException("Unable to find the agencies ", (Throwable)e);
            }
            catch (JsonProcessingException | InvalidParseOperationException e1) {
                throw new BadRequestException("Error parsing query ", e1);
            }
        }
        LOGGER.debug("origin agencies  found {} ", agencies);
        return agencies;
    }

    public List<AgencyModelDto> findOriginAgenciesByCodes(VitamContext vitamContext, Set<String> originAgenciesCodes) throws VitamClientException {
        ArrayList<String> originAgenciesCodesList = new ArrayList<String>(originAgenciesCodes);
        return this.findOriginAgenciesByCriteria(vitamContext, "Identifier", originAgenciesCodesList);
    }

    public List<AgencyModelDto> findOriginAgenciesByNames(VitamContext vitamContext, Set<String> originAgenciesCodes) throws VitamClientException {
        ArrayList<String> originAgenciesCodesList = new ArrayList<String>(originAgenciesCodes);
        return this.findOriginAgenciesByCriteria(vitamContext, "Name", originAgenciesCodesList);
    }
}

