/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.rest;

import fr.gouv.vitamui.archives.search.server.searchcriteria.service.SearchCriteriaHistoryService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/searchcriteriahistory"})
@Api(tags={"searchCriteriaHistory"}, value="Search Criteria History management")
public class SearchCriteriaHistoryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchCriteriaHistoryController.class);
    private final SearchCriteriaHistoryService searchCriteriaHistoryService;

    @Autowired
    public SearchCriteriaHistoryController(SearchCriteriaHistoryService searchCriteriaHistoryService) {
        this.searchCriteriaHistoryService = searchCriteriaHistoryService;
    }

    @GetMapping
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistory() {
        LOGGER.debug("getSearchCriteriaHistory archive external");
        return this.searchCriteriaHistoryService.getSearchCriteriaHistoryDtos();
    }

    @PostMapping
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public SearchCriteriaHistoryDto createSearchCriteriaHistory(@Valid @RequestBody SearchCriteriaHistoryDto dto) throws PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create SearchCriteriaHistory {}", (Object)dto);
        return (SearchCriteriaHistoryDto)this.searchCriteriaHistoryService.create((IdDto)dto);
    }

    @DeleteMapping(value={"/{id}"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public void deleteSearchCriteriaHistory(@PathVariable(value="id") String id) throws PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete SearchCriteriaHistory with id :{}", (Object)id);
        this.searchCriteriaHistoryService.delete(id);
    }

    @ApiOperation(value="Update Search criteria history")
    @PutMapping(value={"/{id}"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public void updateSearchCriteriaHistory(@RequestBody SearchCriteriaHistoryDto entity) throws PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)entity);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{entity.getId()});
        LOGGER.debug("Update SearchCriteriaHistory with id :{}", (Object)entity.getId());
        this.searchCriteriaHistoryService.update((IdDto)entity);
    }
}

