/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchEliminationService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchMgtRulesService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchUnitExportCsvService;
import fr.gouv.vitamui.archives.search.server.service.ExportDipService;
import fr.gouv.vitamui.archives.search.server.service.TransferVitamOperationsService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Api(tags={"Archives search"})
@RequestMapping(value={"/archives-search"})
@RestController
@ResponseBody
public class ArchivesSearchController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchivesSearchController.class);
    private static final String MANDATORY_QUERY = "The query is a mandatory parameter: ";
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private final ArchiveSearchService archiveSearchService;
    private final ArchiveSearchUnitExportCsvService archiveSearchUnitExportCsvService;
    private final ExportDipService exportDipService;
    private final TransferVitamOperationsService transferVitamOperationsService;
    private final ArchiveSearchEliminationService archiveSearchEliminationService;
    private final ArchiveSearchMgtRulesService archiveSearchMgtRulesService;

    @Autowired
    public ArchivesSearchController(ArchiveSearchService archiveSearchService, ArchiveSearchUnitExportCsvService archiveSearchUnitExportCsvService, ExportDipService exportDipService, TransferVitamOperationsService transferVitamOperationsService, ArchiveSearchEliminationService archiveSearchEliminationService, ArchiveSearchMgtRulesService archiveSearchMgtRulesService) {
        this.archiveSearchService = archiveSearchService;
        this.archiveSearchUnitExportCsvService = archiveSearchUnitExportCsvService;
        this.exportDipService = exportDipService;
        this.transferVitamOperationsService = transferVitamOperationsService;
        this.archiveSearchEliminationService = archiveSearchEliminationService;
        this.archiveSearchMgtRulesService = archiveSearchMgtRulesService;
    }

    @PostMapping(value={"/search"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public VitamUIArchiveUnitResponseDto searchArchiveUnitsByCriteria(@RequestBody SearchCriteriaDto query) throws VitamClientException, IOException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling search archive Units By Criteria {} ", (Object)query);
        return this.archiveSearchService.searchArchiveUnitsByCriteria(query);
    }

    @GetMapping(value={"/filling-holding-schema"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public VitamUISearchResponseDto getFillingHoldingScheme() throws VitamClientException {
        return this.archiveSearchService.getFillingHoldingScheme();
    }

    @GetMapping(value={"/downloadobjectfromunit/{id}"}, produces={"application/octet-stream"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_BINARY"})
    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(@PathVariable(value="id") String id, @RequestParam(value="usage", required=false) String usage, @RequestParam(value="version", required=false) Integer version) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the Archive Unit Object with id {} ", (Object)id);
        return this.archiveSearchService.downloadObjectFromUnit(id, usage, version);
    }

    @GetMapping(value={"/archiveunit/{id}"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public ResultsDto findUnitById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("the UA by id {} ", (Object)id);
        return this.archiveSearchService.findArchiveUnitById(id);
    }

    @GetMapping(value={"/object/{id}"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public ResultsDto findObjectById(@PathVariable(value="id") String id) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find a ObjectGroup by id {} ", (Object)id);
        return this.archiveSearchService.findObjectById(id);
    }

    @PostMapping(value={"/export-csv-search"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public Resource exportCsvArchiveUnitsByCriteria(@RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling export to csv search archive Units By Criteria {} ", (Object)query);
        return this.archiveSearchUnitExportCsvService.exportToCsvSearchArchiveUnitsByCriteria(query);
    }

    @PostMapping(value={"/export-dip"})
    @Secured(value={"ROLE_EXPORT_DIP"})
    public String exportDIPByCriteria(@RequestBody ExportDipCriteriaDto exportDipCriteriaDto) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{exportDipCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)exportDipCriteriaDto);
        LOGGER.debug("Calling export DIP By Criteria {} ", (Object)exportDipCriteriaDto);
        return this.exportDipService.requestToExportDIP(exportDipCriteriaDto);
    }

    @PostMapping(value={"/transfer-request"})
    @Secured(value={"ROLE_TRANSFER_REQUEST"})
    public String transferRequest(@RequestBody TransferRequestDto transferRequestDto) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{transferRequestDto});
        SanityChecker.sanitizeCriteria((Object)transferRequestDto);
        LOGGER.debug("Calling transfer request {} ", (Object)transferRequestDto);
        return this.transferVitamOperationsService.transferRequest(transferRequestDto);
    }

    @PostMapping(value={"/elimination/analysis"})
    @Secured(value={"ROLE_ELIMINATION"})
    public JsonNode startEliminationAnalysis(@RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling elimination analysis by criteria {} ", (Object)query);
        return this.archiveSearchEliminationService.startEliminationAnalysis(query);
    }

    @PostMapping(value={"/elimination/action"})
    @Secured(value={"ROLE_ELIMINATION"})
    public JsonNode startEliminationAction(@RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling elimination action by criteria {} ", (Object)query);
        return this.archiveSearchEliminationService.startEliminationAction(query);
    }

    @PostMapping(value={"/elimination/unit-tree/action"})
    @Secured(value={"ROLE_ELIMINATION"})
    public JsonNode startEliminationUnitTreeAction(@RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling elimination action by criteria {} ", (Object)query);
        return this.archiveSearchEliminationService.startEliminationAction(query);
    }

    @PostMapping(value={"/units/rules"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_UPDATE_ARCHIVE_UNIT"})
    public String updateArchiveUnitsRules(@RequestBody RuleSearchCriteriaDto ruleSearchCriteriaDto) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{ruleSearchCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)ruleSearchCriteriaDto);
        LOGGER.debug("Calling Update Archive Units Rules By Criteria {} ", (Object)ruleSearchCriteriaDto);
        return this.archiveSearchMgtRulesService.updateArchiveUnitsRules(ruleSearchCriteriaDto);
    }

    @PostMapping(value={"/computed-inherited-rules"})
    @Secured(value={"ROLE_COMPUTED_INHERITED_RULES"})
    public String computedInheritedRules(@RequestBody SearchCriteriaDto searchCriteriaDto) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{searchCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)searchCriteriaDto);
        LOGGER.debug("Calling computed inherited rules By Criteria {} ", (Object)searchCriteriaDto);
        return this.archiveSearchService.computedInheritedRules(searchCriteriaDto);
    }

    @PostMapping(value={"/unit-with-inherited-rules"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public ResultsDto selectUnitWithInheritedRules(@RequestBody SearchCriteriaDto query) throws PreconditionFailedException, VitamClientException, IOException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling select Unit With Inherited Rules By Criteria {} ", (Object)query);
        return this.archiveSearchService.selectUnitWithInheritedRules(query);
    }

    @PostMapping(value={"/reclassification"})
    @Secured(value={"ROLE_RECLASSIFICATION"})
    public String reclassification(@RequestBody ReclassificationCriteriaDto reclassificationCriteriaDto) throws PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{reclassificationCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)reclassificationCriteriaDto);
        LOGGER.debug("Reclassification query {}", (Object)reclassificationCriteriaDto);
        return this.archiveSearchService.reclassification(reclassificationCriteriaDto);
    }

    @ApiOperation(value="Upload an ATR file for the transfer acknowledgment", consumes="application/octet-stream")
    @Secured(value={"ROLE_TRANSFER_ACKNOWLEDGMENT"})
    @PostMapping(value={"/transfer-acknowledgment"}, consumes={"application/octet-stream"})
    public String transferAcknowledgment(InputStream inputStream) throws PreconditionFailedException, VitamClientException {
        LOGGER.debug("[EXTERNAL] : Transfer Acknowledgment Operation");
        return this.transferVitamOperationsService.transferAcknowledgment(inputStream);
    }

    @GetMapping(value={"/external-ontologies"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public List<VitamUiOntologyDto> getExternalOntologiesList() throws IOException {
        LOGGER.debug("[EXTERNAL] : Get External ontologies list");
        return this.archiveSearchService.readExternalOntologiesFromFile();
    }

    @GetMapping(value={"/units-by-persistent-identifier"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_SEARCH"})
    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(@RequestParam(value="id") String arkId) throws VitamClientException {
        LOGGER.debug("[EXTERNAL] : Get units by persistent identifier {}", (Object)arkId);
        PersistentIdentifierResponseDto persistentIdentifierResponse = this.archiveSearchService.findUnitsByPersistentIdentifier(arkId);
        LOGGER.debug("[EXTERNAL] : persistentIdentifierResponse = {}", (Object)persistentIdentifierResponse);
        return persistentIdentifierResponse;
    }

    @GetMapping(value={"/objects-by-persistent-identifier"})
    @Secured(value={"ROLE_ARCHIVE_SEARCH_GET_ARCHIVE_BINARY"})
    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(@RequestParam(value="id") String arkId) throws VitamClientException {
        LOGGER.debug("[EXTERNAL] : Get objects by persistent identifier {}", (Object)arkId);
        PersistentIdentifierResponseDto persistentIdentifierResponse = this.archiveSearchService.findObjectsByPersistentIdentifier(arkId);
        LOGGER.debug("[EXTERNAL] : persistentIdentifierResponse = {}", (Object)persistentIdentifierResponse);
        return persistentIdentifierResponse;
    }
}

