/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.converter;

import fr.gouv.vitam.common.model.massupdate.ManagementMetadataAction;
import fr.gouv.vitam.common.model.massupdate.RuleAction;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryAction;
import fr.gouv.vitam.common.model.massupdate.RuleCategoryActionDeletion;
import fr.gouv.vitamui.archives.search.common.dto.VitamUiManagementMetadataAction;
import fr.gouv.vitamui.archives.search.common.dto.VitamUiRuleAction;
import fr.gouv.vitamui.archives.search.common.dto.VitamUiRuleActions;
import fr.gouv.vitamui.archives.search.common.dto.VitamUiRuleCategoryAction;
import fr.gouv.vitamui.archives.search.common.dto.VitamUiRuleCategoryActionDeletion;
import fr.gouv.vitamui.commons.api.utils.ArchiveSearchConsts;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;

public class RuleOperationsConverter {
    public ManagementMetadataAction convertToVitamManagementMetadataAction(VitamUiManagementMetadataAction vitamUiManagementMetadataAction) {
        return (ManagementMetadataAction)VitamUIUtils.copyProperties((Object)vitamUiManagementMetadataAction, (Object)new ManagementMetadataAction());
    }

    public RuleAction convertToVitamRuleAction(VitamUiRuleAction vitamUiRuleAction) {
        RuleAction ruleAction = (RuleAction)VitamUIUtils.copyProperties((Object)vitamUiRuleAction, (Object)new RuleAction());
        if (vitamUiRuleAction.getStartDate() != null) {
            LocalDateTime startDate = LocalDateTime.parse(vitamUiRuleAction.getStartDate(), ArchiveSearchConsts.ISO_FRENCH_FORMATER).withHour(0).withMinute(0).withSecond(0).withNano(0);
            ruleAction.setStartDate(ArchiveSearchConsts.ONLY_DATE_FRENCH_FORMATER.format(startDate.plusDays(1L)));
        }
        return ruleAction;
    }

    public RuleActions convertToVitamRuleActions(VitamUiRuleActions vitamUiRuleActions) {
        RuleActions ruleActions = (RuleActions)VitamUIUtils.copyProperties((Object)vitamUiRuleActions, (Object)new RuleActions());
        ArrayList vitamAdd = new ArrayList();
        ArrayList vitamDelete = new ArrayList();
        ArrayList vitamUpdate = new ArrayList();
        if (vitamUiRuleActions != null && vitamUiRuleActions.getAddOrUpdateMetadata() != null) {
            ruleActions.setAddOrUpdateMetadata(this.convertToVitamManagementMetadataAction(vitamUiRuleActions.getAddOrUpdateMetadata()));
        }
        if (vitamUiRuleActions != null && vitamUiRuleActions.getDeleteMetadata() != null) {
            ruleActions.setDeleteMetadata(this.convertToVitamManagementMetadataAction(vitamUiRuleActions.getDeleteMetadata()));
        }
        if (vitamUiRuleActions != null && !vitamUiRuleActions.getAdd().isEmpty()) {
            vitamUiRuleActions.getAdd().forEach(rule -> {
                HashMap map = new HashMap();
                rule.keySet().forEach(ruleCategoryActionKey -> map.put(ruleCategoryActionKey, this.convertToRuleCategoryAction((VitamUiRuleCategoryAction)rule.get(ruleCategoryActionKey))));
                vitamAdd.add(map);
            });
            ruleActions.setAdd(vitamAdd);
        }
        if (vitamUiRuleActions != null && !vitamUiRuleActions.getUpdate().isEmpty()) {
            vitamUiRuleActions.getUpdate().forEach(rule -> {
                HashMap map = new HashMap();
                rule.keySet().forEach(ruleCategoryActionKey -> map.put(ruleCategoryActionKey, this.convertToRuleCategoryAction((VitamUiRuleCategoryAction)rule.get(ruleCategoryActionKey))));
                vitamUpdate.add(map);
            });
            ruleActions.setUpdate(vitamUpdate);
        }
        if (vitamUiRuleActions != null && !vitamUiRuleActions.getDelete().isEmpty()) {
            vitamUiRuleActions.getDelete().forEach(rule -> {
                HashMap map = new HashMap();
                rule.keySet().forEach(ruleCategoryActionKey -> map.put(ruleCategoryActionKey, this.convertToRuleCategoryActionDeletion((VitamUiRuleCategoryActionDeletion)rule.get(ruleCategoryActionKey))));
                vitamDelete.add(map);
            });
            ruleActions.setDelete(vitamDelete);
        }
        return ruleActions;
    }

    public RuleCategoryAction convertToRuleCategoryAction(VitamUiRuleCategoryAction vitamUiRuleCategoryAction) {
        RuleCategoryAction ruleCategoryAction = (RuleCategoryAction)VitamUIUtils.copyProperties((Object)vitamUiRuleCategoryAction, (Object)new RuleCategoryAction());
        ArrayList ruleActionList = new ArrayList();
        if (vitamUiRuleCategoryAction != null && vitamUiRuleCategoryAction.getRules() != null) {
            vitamUiRuleCategoryAction.getRules().forEach(rule -> ruleActionList.add(this.convertToVitamRuleAction((VitamUiRuleAction)rule)));
            ruleCategoryAction.setRules(ruleActionList);
        }
        return ruleCategoryAction;
    }

    public RuleCategoryActionDeletion convertToRuleCategoryActionDeletion(VitamUiRuleCategoryActionDeletion vitamUiRuleCategoryActionDeletion) {
        RuleCategoryActionDeletion ruleCategoryActionDeletion = (RuleCategoryActionDeletion)VitamUIUtils.copyProperties((Object)vitamUiRuleCategoryActionDeletion, (Object)new RuleCategoryActionDeletion());
        ArrayList ruleActionList = new ArrayList();
        if (vitamUiRuleCategoryActionDeletion != null && vitamUiRuleCategoryActionDeletion.getRules() != null) {
            vitamUiRuleCategoryActionDeletion.getRules().ifPresent(ruleCategoryAction -> {
                ruleCategoryAction.forEach(rule -> ruleActionList.add(this.convertToVitamRuleAction((VitamUiRuleAction)rule)));
                ruleCategoryActionDeletion.setRules(ruleActionList);
            });
        }
        return ruleCategoryActionDeletion;
    }

    @Generated
    public RuleOperationsConverter() {
    }
}

