/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.server.config;

import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.v2.AccessExternalClientV2;
import fr.gouv.vitamui.archives.search.common.dto.converter.UpdateArchiveUnitDtoToUpdateMultiQueryConverter;
import fr.gouv.vitamui.archives.search.common.service.ArchiveUnitService;
import fr.gouv.vitamui.archives.search.server.config.ApiArchiveApplicationProperties;
import fr.gouv.vitamui.archives.search.server.config.ConverterConfig;
import fr.gouv.vitamui.archives.search.server.config.MongoDbConfig;
import fr.gouv.vitamui.archives.search.server.converter.RuleOperationsConverter;
import fr.gouv.vitamui.archives.search.server.searchcriteria.converter.SearchCriteriaHistoryConverter;
import fr.gouv.vitamui.archives.search.server.searchcriteria.dao.SearchCriteriaHistoryRepository;
import fr.gouv.vitamui.archives.search.server.searchcriteria.service.SearchCriteriaHistoryService;
import fr.gouv.vitamui.archives.search.server.security.WebSecurityConfig;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchExternalParametersService;
import fr.gouv.vitamui.archives.search.server.service.ArchiveSearchUnitServiceImpl;
import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.api.converter.JsonPatchDtoToUpdateMultiQueryConverter;
import fr.gouv.vitamui.commons.api.converter.UpdateMultiQueriesToBulkCommandDto;
import fr.gouv.vitamui.commons.mongo.dao.CustomSequenceRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.commons.vitam.api.access.ExportDipV2Service;
import fr.gouv.vitamui.commons.vitam.api.access.TransferAcknowledgmentService;
import fr.gouv.vitamui.commons.vitam.api.access.TransferRequestService;
import fr.gouv.vitamui.commons.vitam.api.access.UnitCommonService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.iam.client.ExternalParametersRestClient;
import fr.gouv.vitamui.iam.client.IamRestClientFactory;
import fr.gouv.vitamui.iam.client.UserRestClient;
import fr.gouv.vitamui.iam.security.provider.ApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.provider.InternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.IamClientUserAuthenticationService;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={RestExceptionHandler.class, SwaggerConfiguration.class, HttpMessageConvertersAutoConfiguration.class, WebSecurityConfig.class, VitamAccessConfig.class, VitamAdministrationConfig.class, MongoDbConfig.class, ConverterConfig.class})
public class ApiArchiveServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SequenceGeneratorService sequenceGeneratorService(CustomSequenceRepository sequenceRepository) {
        return new SequenceGeneratorService(sequenceRepository);
    }

    @Bean
    public SecurityRestClientFactory securityRestClientFactory(ApiArchiveApplicationProperties apiArchiveExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityRestClientFactory(apiArchiveExternalApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public UserAuthenticationService authentificationService(UserRestClient userRestClient) {
        return new IamClientUserAuthenticationService(userRestClient);
    }

    @Bean
    public InternalApiAuthenticationProvider internalApiAuthenticationProvider(UserAuthenticationService userAuthenticationService) {
        return new InternalApiAuthenticationProvider(userAuthenticationService);
    }

    @Bean
    public ExternalApiAuthenticationProvider externalApiAuthenticationProvider(SecurityRestClientFactory securityRestClientFactory, UserAuthenticationService userAuthenticationService) {
        return new ExternalApiAuthenticationProvider(securityRestClientFactory.getContextRestClient(), userAuthenticationService);
    }

    @Bean
    public ApiAuthenticationProvider apiAuthenticationProvider(InternalApiAuthenticationProvider internalApiAuthenticationProvider, ExternalApiAuthenticationProvider externalApiAuthenticationProvider) {
        return new ApiAuthenticationProvider(internalApiAuthenticationProvider, externalApiAuthenticationProvider);
    }

    @Bean
    public SecurityService securityService() {
        return new SecurityService();
    }

    @Bean
    public IamRestClientFactory iamRestClientFactory(ApiArchiveApplicationProperties apiArchiveExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamRestClientFactory(apiArchiveExternalApplicationProperties.getIamClient(), restTemplateBuilder);
    }

    @Bean
    public UserRestClient userRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getUserExternalRestClient();
    }

    @Bean
    public ExternalParametersRestClient externalParametersRestClient(IamRestClientFactory iamRestClientFactory) {
        return iamRestClientFactory.getExternalParametersExternalRestClient();
    }

    @Bean
    public UnitCommonService unitCommonService(AccessExternalClient client) {
        return new UnitCommonService(client);
    }

    @Bean
    public ExportDipV2Service exportDipV2Service(AccessExternalClientV2 accessExternalClientV2) {
        return new ExportDipV2Service(accessExternalClientV2);
    }

    @Bean
    public TransferRequestService transferRequestService(AccessExternalClient accessExternalClient) {
        return new TransferRequestService(accessExternalClient);
    }

    @Bean
    public TransferAcknowledgmentService transferAcknowledgmentService(AccessExternalClient accessExternalClient) {
        return new TransferAcknowledgmentService(accessExternalClient);
    }

    @Bean
    public SearchCriteriaHistoryService searchCriteriaHistoryService(SequenceGeneratorService sequenceGeneratorService, SearchCriteriaHistoryRepository searchCriteriaHistoryRepository, SearchCriteriaHistoryConverter searchCriteriaHistoryConverter, SecurityService securityService) {
        return new SearchCriteriaHistoryService(sequenceGeneratorService, searchCriteriaHistoryRepository, searchCriteriaHistoryConverter, securityService);
    }

    @Bean
    public RuleOperationsConverter ruleOperationsConverter() {
        return new RuleOperationsConverter();
    }

    @Bean
    public ArchiveUnitService archiveUnitService(AccessExternalClient accessExternalClient, UpdateArchiveUnitDtoToUpdateMultiQueryConverter updateArchiveUnitDtoToUpdateMultiQueryConverter, ArchiveSearchExternalParametersService externalParametersService, JsonPatchDtoToUpdateMultiQueryConverter jsonPatchDtoToUpdateMultiQueryConverter, UpdateMultiQueriesToBulkCommandDto updateMultiQueriesToBulkCommandDto) {
        return new ArchiveSearchUnitServiceImpl(accessExternalClient, updateArchiveUnitDtoToUpdateMultiQueryConverter, externalParametersService, jsonPatchDtoToUpdateMultiQueryConverter, updateMultiQueriesToBulkCommandDto);
    }
}

