/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Map;
import org.springframework.util.StringUtils;

public class MapEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        Map partialDto = (Map)this.getValue();
        return partialDto.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map partialDto = (Map)mapper.readValue(text, (TypeReference)new TypeReference<Map<String, Object>>(){});
                this.setValue(partialDto);
            }
            catch (IOException e) {
                throw new BadRequestException("Invalid partial dto format", (Throwable)e);
            }
        } else {
            this.setValue(null);
        }
    }
}

