/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.enums.AuthnRequestBindingEnum;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public class IdentityProviderBuilder {
    private final String name;
    private final String technicalName;
    private final Boolean enabled;
    private final Boolean internal;
    private final List<String> patterns;
    private final Resource keystore;
    private final String keystorePassword;
    private final String privateKeyPassword;
    private final Resource idpMetadata;
    private final String customerId;
    private final boolean readonly;
    private final String mailAttribute;
    private final String identifierAttribute;
    private final AuthnRequestBindingEnum authnRequestBinding;
    private final Integer maximumAuthenticationLifetime;
    private final boolean wantsAssertionsSigned;
    private final boolean authnRequestSigned;
    private final boolean propagateLogout;
    private final boolean autoProvisioningEnabled;
    private String clientId;
    private String clientSecret;
    private String discoveryUrl;
    private String scope;
    private String preferredJwsAlgorithm;
    private Map<String, String> customParams;
    private Boolean useState;
    private Boolean useNonce;
    private Boolean usePkce;
    private String protocoleType;

    public IdentityProviderBuilder(String name, String technicalName, Boolean enabled, Boolean internal, List<String> patterns, Resource keystore, String keystorePassword, String privateKeyPassword, Resource idpMetadata, String customerId, Boolean readonly, String mailAttribute, String identifierAttribute, Integer maximumAuthenticationLifetime, AuthnRequestBindingEnum authnRequestBinding, Boolean wantsAssertionsSigned, Boolean authnRequestSigned, boolean propagateLogout, Boolean autoProvisioningEnabled, String clientId, String clientSecret, String discoveryUrl, String scope, String preferredJwsAlgorithm, Map<String, String> customParams, Boolean useState, Boolean useNonce, Boolean usePkce, String protocoleType) {
        this.name = name;
        this.technicalName = technicalName;
        this.enabled = enabled;
        this.internal = internal;
        this.patterns = patterns;
        this.keystore = keystore;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.idpMetadata = idpMetadata;
        this.customerId = customerId;
        this.readonly = readonly;
        this.mailAttribute = mailAttribute;
        this.identifierAttribute = identifierAttribute;
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        this.authnRequestBinding = authnRequestBinding;
        this.wantsAssertionsSigned = wantsAssertionsSigned;
        this.authnRequestSigned = authnRequestSigned;
        this.propagateLogout = propagateLogout;
        this.autoProvisioningEnabled = autoProvisioningEnabled;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.discoveryUrl = discoveryUrl;
        this.scope = scope;
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
        this.customParams = customParams;
        this.useNonce = useNonce;
        this.usePkce = usePkce;
        this.useState = useState;
        this.protocoleType = protocoleType;
    }

    public IdentityProviderDto build() throws Exception {
        IdentityProviderDto idp = new IdentityProviderDto();
        idp.setName(this.name);
        idp.setTechnicalName(this.technicalName);
        idp.setEnabled(this.enabled);
        idp.setInternal(this.internal);
        idp.setPatterns(this.patterns);
        idp.setReadonly(this.readonly);
        idp.setMailAttribute(this.mailAttribute);
        idp.setIdentifierAttribute(this.identifierAttribute);
        idp.setMaximumAuthenticationLifetime(this.maximumAuthenticationLifetime);
        idp.setAuthnRequestBinding(this.authnRequestBinding);
        idp.setWantsAssertionsSigned(this.wantsAssertionsSigned);
        idp.setAuthnRequestSigned(this.authnRequestSigned);
        idp.setPropagateLogout(this.propagateLogout);
        idp.setClientId(this.clientId);
        idp.setClientSecret(this.clientSecret);
        idp.setDiscoveryUrl(this.discoveryUrl);
        idp.setScope(this.scope);
        idp.setPreferredJwsAlgorithm(this.preferredJwsAlgorithm);
        idp.setCustomParams(this.customParams);
        idp.setUseState(this.useState);
        idp.setUseNonce(this.useNonce);
        idp.setUsePkce(this.usePkce);
        idp.setProtocoleType(this.protocoleType);
        IdentityProviderBuilder.extractKeystore(idp, this.keystore);
        if (this.keystorePassword != null) {
            idp.setKeystorePassword(this.keystorePassword);
        }
        if (this.privateKeyPassword != null) {
            idp.setPrivateKeyPassword(this.privateKeyPassword);
        }
        IdentityProviderBuilder.extractIdpMetadata(idp, this.idpMetadata);
        idp.setCustomerId(this.customerId);
        idp.setAutoProvisioningEnabled(this.autoProvisioningEnabled);
        return idp;
    }

    public static void extractIdpMetadata(IdentityProviderDto idp, Resource idpMetadata) throws IOException {
        if (idpMetadata != null) {
            try (InputStream isIdpMeta = idpMetadata.getInputStream();){
                String idpMeta = IOUtils.toString((InputStream)isIdpMeta, (String)"UTF-8");
                idp.setIdpMetadata(idpMeta);
            }
        }
    }

    public static void extractKeystore(IdentityProviderDto idp, Resource keystore) throws IOException, UnsupportedEncodingException {
        if (keystore != null) {
            try (InputStream isKeystore = keystore.getInputStream();){
                byte[] keystoreArray = IOUtils.toByteArray((InputStream)isKeystore);
                String keystoreBase64 = new String(Base64.getEncoder().encode(keystoreArray), "UTF-8");
                idp.setKeystoreBase64(keystoreBase64);
            }
        }
    }
}

