/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.client;

import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CustomerRestClient
extends BasePaginatingAndSortingRestClient<CustomerDto, HttpContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerRestClient.class);

    public CustomerRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public CustomerDto getMyCustomer(HttpContext context) {
        LOGGER.debug("GetMyCustomer");
        HttpEntity request = new HttpEntity(this.buildHeaders(context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/me"));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, CustomerDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (CustomerDto)response.getBody();
    }

    public String getPathUrl() {
        return "/iam/v1/customers";
    }

    protected Class<CustomerDto> getDtoClass() {
        return CustomerDto.class;
    }

    protected ParameterizedTypeReference<List<CustomerDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CustomerDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CustomerDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CustomerDto>>(){};
    }

    @Deprecated
    public CustomerDto create(HttpContext context, CustomerDto dto) {
        return (CustomerDto)super.create(context, (IdDto)dto);
    }

    public ResponseEntity<Resource> getCustomerLogo(HttpContext context, String id) {
        LOGGER.debug("Get logo for customer with id {}", (Object)id);
        URIBuilder builder = this.getUriBuilderFromPath("/" + id + "/logo");
        HttpEntity request = new HttpEntity(this.buildHeaders(context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, Resource.class);
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public ResponseEntity<Resource> getLogo(HttpContext context, String id, AttachmentType type) {
        LOGGER.debug("Get logo for customer with id {}, type {}", (Object)id, (Object)type);
        URIBuilder builder = this.getUriBuilderFromPath("/" + id + "/logo?type=" + String.valueOf(type));
        HttpEntity request = new HttpEntity(this.buildHeaders(context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, Resource.class);
        this.checkResponse(response, new Integer[]{200, 204});
        return response;
    }

    public boolean getGdprSettingStatus(HttpContext context) {
        LOGGER.debug("get Gdpr Setting Status");
        HttpEntity request = new HttpEntity(this.buildHeaders(context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/gdpr-status"));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, Boolean.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (Boolean)response.getBody();
    }
}

