/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.client;

import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.rest.client.BaseCrudRestClient;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import java.net.URI;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ApplicationRestClient
extends BaseCrudRestClient<ApplicationDto, HttpContext> {
    private static final String IDENTIFIER_EXTERNAL_PATH = "/{identifier}/externalid";

    public ApplicationRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/iam/v1/applications";
    }

    protected Class<ApplicationDto> getDtoClass() {
        return ApplicationDto.class;
    }

    protected ParameterizedTypeReference<List<ApplicationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ApplicationDto>>(){};
    }

    public ResponseEntity<Boolean> isApplicationExternalIdentifierEnabled(HttpContext context, String applicationId) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + IDENTIFIER_EXTERNAL_PATH)).build(new Object[]{applicationId});
        return this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity(this.buildHeaders(context)), Boolean.class);
    }
}

