/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.standalone.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.pastis.common.service.JsonFromPUA;
import fr.gouv.vitamui.pastis.common.service.PuaFromJSON;
import fr.gouv.vitamui.pastis.common.service.PuaPastisValidator;
import fr.gouv.vitamui.pastis.server.service.ExternalSchemaService;
import fr.gouv.vitamui.pastis.server.service.MetaModelService;
import fr.gouv.vitamui.pastis.server.service.PastisService;
import fr.gouv.vitamui.pastis.standalone.service.ExternalSchemaServiceStandaloneImpl;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;

@Configuration
public class PastisConfiguration {
    @Value(value="${pastis.client.url}")
    public String url;

    @Bean
    public ErrorViewResolver customErrorViewResolver() {
        ModelAndView redirectToIndexHtml = new ModelAndView("forward:/index.html", Collections.emptyMap(), HttpStatus.OK);
        return (request, status, model) -> status == HttpStatus.NOT_FOUND ? redirectToIndexHtml : null;
    }

    @Bean
    public SecurityService externalSecurityService() {
        return new SecurityService();
    }

    @Bean
    public JsonFromPUA jsonFromPUA() {
        return new JsonFromPUA();
    }

    @Bean
    public PuaFromJSON puaFromJSON() {
        return new PuaFromJSON(this.puaPastisValidator());
    }

    @Bean
    public PastisService pastisService() {
        ObjectMapper objectMapper = new ObjectMapper();
        return new PastisService(objectMapper, null, this.puaPastisValidator(), this.jsonFromPUA(), this.puaFromJSON(), new MetaModelService((ExternalSchemaService)new ExternalSchemaServiceStandaloneImpl(objectMapper)), null, this.externalSecurityService());
    }

    @Bean
    public PuaPastisValidator puaPastisValidator() {
        return new PuaPastisValidator();
    }
}

