/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileResponseDto;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileVitamDto;
import fr.gouv.vitamui.referential.common.service.VitamContextCommonService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class VitamSecurityProfileCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamContextCommonService.class);
    private final AdminExternalClient adminExternalClient;
    private final ObjectMapper objectMapper;

    @Autowired
    public VitamSecurityProfileCommonService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper) {
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
    }

    public RequestResponse<?> patchSecurityProfile(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws VitamClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.debug("Patch Security Profile EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        return this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }

    public RequestResponse<?> deleteSecurityProfile(VitamContext vitamContext, String id) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Delete Security Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse requestResponse = this.adminExternalClient.findSecurityProfiles(vitamContext, (JsonNode)new Select().getFinalSelect());
        List actualSecurityProfiles = ((SecurityProfileResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), SecurityProfileResponseDto.class))).getResults();
        return this.importSecurityProfiles(vitamContext, actualSecurityProfiles.stream().filter(securityProfile -> !id.equals(securityProfile.getIdentifier())).collect(Collectors.toList()));
    }

    public RequestResponse<SecurityProfileModel> findSecurityProfiles(VitamContext vitamSecurityProfile, JsonNode select) throws VitamClientException {
        LOGGER.debug("All Security Profiles EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, select);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<SecurityProfileModel> findSecurityProfileById(VitamContext vitamSecurityProfile, String securityProfileId) throws VitamClientException {
        LOGGER.debug("Security Profile EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<?> createSecurityProfile(VitamContext vitamSecurityProfile, SecurityProfileModel newSecurityProfile) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.info("Create Security Profile EvIdAppSession : {} ", (Object)vitamSecurityProfile.getApplicationSessionId());
        ArrayList<SecurityProfileModel> actualSecurityProfiles = new ArrayList<SecurityProfileModel>();
        if (StringUtils.isBlank((CharSequence)newSecurityProfile.getIdentifier())) {
            newSecurityProfile.setIdentifier(newSecurityProfile.getName());
        }
        actualSecurityProfiles.add(newSecurityProfile);
        return this.importSecurityProfiles(vitamSecurityProfile, actualSecurityProfiles);
    }

    private RequestResponse importSecurityProfiles(VitamContext vitamSecurityProfile, List<SecurityProfileModel> agenciesModel) throws InvalidParseOperationException, AccessExternalClientException, IOException, VitamClientException {
        LOGGER.debug("Reimport securityProfileies {}", agenciesModel);
        return this.importSecurityProfiles(vitamSecurityProfile, agenciesModel, "SecurityProfiles.json");
    }

    private RequestResponse importSecurityProfiles(VitamContext vitamSecurityProfile, List<SecurityProfileModel> securityProfileModels, String fileName) throws InvalidParseOperationException, AccessExternalClientException, IOException, VitamClientException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeSecurityProfiles(securityProfileModels);){
            RequestResponse<?> requestResponse = this.importSecurityProfiles(vitamSecurityProfile, byteArrayInputStream, fileName);
            return requestResponse;
        }
    }

    private RequestResponse<?> importSecurityProfiles(VitamContext vitamSecurityProfile, InputStream agencies, String fileName) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException {
        return this.adminExternalClient.createSecurityProfiles(vitamSecurityProfile, agencies, fileName);
    }

    public boolean checkAbilityToCreateSecurityProfileInVitam(List<SecurityProfileModel> securityProfiles, VitamContext vitamSecurityProfile) {
        if (securityProfiles != null && !securityProfiles.isEmpty()) {
            try {
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<SecurityProfileModel> response = this.findSecurityProfiles(vitamSecurityProfile, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    LOGGER.error("Can't create Security Profile for the tenant : {}  not found in Vitam", (Object)vitamSecurityProfile.getTenantId());
                    throw new NotFoundException("Can't create Security Profile for the tenant : UNAUTHORIZED");
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    LOGGER.error("Can't create Security Profile for this tenant");
                    throw new UnavailableServiceException("Can't create Security Profile for this tenant, Vitam response code : " + response.getStatus());
                }
                this.verifySecurityProfileExistence(securityProfiles, response);
            }
            catch (VitamClientException e) {
                LOGGER.error("Can't create Security Profile for this tenant, error while calling Vitam ");
                throw new UnavailableServiceException("Can't create Security Profile for this tenant, error while calling Vitam : " + e.getMessage());
            }
            return true;
        }
        throw new BadRequestException("The body is not found");
    }

    private void verifySecurityProfileExistence(List<SecurityProfileModel> securityProfileModelList, RequestResponse<SecurityProfileModel> vitamSecurityProfiles) {
        try {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SecurityProfileResponseDto securityProfileResponseDto = (SecurityProfileResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)vitamSecurityProfiles.toJsonNode(), SecurityProfileResponseDto.class));
            List securityProfileNames = securityProfileModelList.stream().map(SecurityProfileModel::getName).filter(Objects::nonNull).map(String::strip).collect(Collectors.toList());
            if (securityProfileResponseDto.getResults().stream().anyMatch(securityProfile -> securityProfileNames.contains(securityProfile.getName()))) {
                String messageError = "Can't create securityProfile, a format with the same name already exist in Vitam";
                LOGGER.error("Can't create securityProfile, a format with the same name already exist in Vitam");
                throw new ConflictException("Can't create securityProfile, a format with the same name already exist in Vitam");
            }
            List securityProfileIds = securityProfileModelList.stream().map(SecurityProfileModel::getIdentifier).filter(Objects::nonNull).map(String::strip).collect(Collectors.toList());
            if (securityProfileResponseDto.getResults().stream().anyMatch(securityProfile -> securityProfileIds.contains(securityProfile.getIdentifier()))) {
                String messageError = "Can't create securityProfile, a Security Profile  with the same identifier already exist in Vitam";
                LOGGER.error("Can't create securityProfile, a Security Profile  with the same identifier already exist in Vitam");
                throw new ConflictException("Can't create securityProfile, a Security Profile  with the same identifier already exist in Vitam");
            }
        }
        catch (JsonProcessingException exception) {
            String errorMessage = "Can't create management contracts, Error while parsing Vitam response : " + exception.getMessage();
            LOGGER.error(errorMessage);
            throw new UnexpectedDataException(errorMessage);
        }
    }

    private ByteArrayInputStream serializeSecurityProfiles(List<SecurityProfileModel> securityProfileModels) throws IOException {
        List<SecurityProfileVitamDto> listOfAC = this.convertSecurityProfilesToModelOfCreation(securityProfileModels);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.convertValue(listOfAC, JsonNode.class);
        LOGGER.debug("The json for creation access contract, sent to Vitam {}", (Object)node);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            mapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private List<SecurityProfileVitamDto> convertSecurityProfilesToModelOfCreation(List<SecurityProfileModel> securityProfileModels) {
        ArrayList<SecurityProfileVitamDto> listOfSP = new ArrayList<SecurityProfileVitamDto>();
        for (SecurityProfileModel securityProfileModel : securityProfileModels) {
            SecurityProfileVitamDto securityProfile = new SecurityProfileVitamDto();
            listOfSP.add((SecurityProfileVitamDto)VitamUIUtils.copyProperties((Object)securityProfileModel, (Object)securityProfile));
        }
        return listOfSP;
    }
}

