/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.common.dto.ContextResponseDto;
import fr.gouv.vitamui.referential.common.dto.ContextVitamDto;
import fr.gouv.vitamui.referential.common.dto.converter.ContextDtoConverterUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class VitamContextCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamContextCommonService.class);
    private final AdminExternalClient adminExternalClient;
    private final ObjectMapper objectMapper;
    private static final String INGEST_CONTRACTS = "ingestContracts";
    private static final String ACCESS_CONTRACTS = "accessContracts";

    @Autowired
    public VitamContextCommonService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper) {
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
    }

    public RequestResponse<?> patchContext(VitamContext vitamContext, String id, JsonNode jsonNode) throws InvalidParseOperationException, AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.info("Patch Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.adminExternalClient.updateContext(vitamContext, id, jsonNode);
    }

    public RequestResponse<ContextModel> findContexts(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        LOGGER.info("Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findContexts(vitamContext, select);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<ContextModel> findContextById(VitamContext vitamContext, String contextId) throws VitamClientException {
        LOGGER.info("Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findContextById(vitamContext, contextId);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<?> createContext(VitamContext vitamContext, ContextDto newContext) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        LOGGER.info("Create Context EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        ArrayList<ContextDto> actualContexts = new ArrayList<ContextDto>();
        if (StringUtils.isBlank((CharSequence)newContext.getIdentifier())) {
            newContext.setIdentifier(newContext.getName());
        }
        actualContexts.add(newContext);
        return this.createContexts(vitamContext, actualContexts);
    }

    private RequestResponse createContexts(VitamContext vitamContext, List<ContextDto> contextModels) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        LOGGER.debug("Reimport contexties {}", contextModels);
        try (ByteArrayInputStream byteArrayInputStream = this.serializeContexts(contextModels);){
            RequestResponse<?> requestResponse = this.createContexts(vitamContext, byteArrayInputStream);
            return requestResponse;
        }
    }

    private RequestResponse<?> createContexts(VitamContext vitamContext, InputStream contexts) throws InvalidParseOperationException, AccessExternalClientException {
        return this.adminExternalClient.createContexts(vitamContext, contexts);
    }

    public boolean checkAbilityToCreateContextInVitam(List<ContextModel> contexts, VitamContext vitamContext) {
        if (contexts != null && !contexts.isEmpty()) {
            try {
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<ContextModel> response = this.findContexts(vitamContext, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    LOGGER.error("Can't create Vitam Contexts for the tenant : {}  not found in Vitam", (Object)vitamContext.getTenantId());
                    throw new NotFoundException("Can't create Vitam Contexts for the tenant : UNAUTHORIZED");
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    LOGGER.error("Can't create Vitam Context for this tenant");
                    throw new UnavailableServiceException("Can't create Vitam Context for this tenant, Vitam response code : " + response.getStatus());
                }
                this.verifyFileFormatExistence(contexts, response);
            }
            catch (VitamClientException exception) {
                LOGGER.error("Can't create Vitam Context for this tenant");
                throw new UnavailableServiceException("Can't create Vitam Contexts for this tenant, error while calling Vitam : " + exception.getMessage());
            }
            return true;
        }
        throw new BadRequestException("The body is not found");
    }

    private void verifyFileFormatExistence(List<ContextModel> contextModelList, RequestResponse<ContextModel> vitamContextModelList) {
        try {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ContextResponseDto contextResponseDto = (ContextResponseDto)((Object)this.objectMapper.treeToValue((TreeNode)vitamContextModelList.toJsonNode(), ContextResponseDto.class));
            List contextNames = contextModelList.stream().map(ContextModel::getName).filter(Objects::nonNull).map(String::strip).collect(Collectors.toList());
            if (contextResponseDto.getResults().stream().anyMatch(context -> contextNames.contains(context.getName()))) {
                String messageError = "Can't create context, an application context with the same name already exist in Vitam";
                LOGGER.error("Can't create context, an application context with the same name already exist in Vitam");
                throw new ConflictException("Can't create context, an application context with the same name already exist in Vitam");
            }
            List contextIds = contextModelList.stream().map(ContextModel::getIdentifier).filter(Objects::nonNull).map(String::strip).collect(Collectors.toList());
            if (contextResponseDto.getResults().stream().anyMatch(context -> contextIds.contains(context.getIdentifier()))) {
                String messageError = "Can't create context, an application context with the same puid already exist in Vitam";
                LOGGER.error("Can't create context, an application context with the same puid already exist in Vitam");
                throw new ConflictException("Can't create context, an application context with the same puid already exist in Vitam");
            }
        }
        catch (JsonProcessingException exception) {
            String messageError = "Can't create application contexts, Error while parsing Vitam response : ";
            LOGGER.error("Can't create application contexts, Error while parsing Vitam response : ");
            throw new UnexpectedDataException("Can't create application contexts, Error while parsing Vitam response : " + exception.getMessage());
        }
    }

    private ByteArrayInputStream serializeContexts(List<ContextDto> contextDto) throws IOException {
        List<ContextVitamDto> listOfContexts = ContextDtoConverterUtil.convertContextsToModelOfCreation(contextDto);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.convertValue(listOfContexts, JsonNode.class);
        ArrayNode arrayNode = (ArrayNode)node;
        arrayNode.forEach(contextNode -> {
            ArrayNode permissionsNode = (ArrayNode)contextNode.get("Permissions");
            if (permissionsNode != null) {
                permissionsNode.forEach(permissionNode -> {
                    ObjectNode objectNode = (ObjectNode)permissionNode;
                    if (permissionNode.get(ACCESS_CONTRACTS) != null) {
                        objectNode.set("AccessContracts", permissionNode.get(ACCESS_CONTRACTS));
                        objectNode.remove(ACCESS_CONTRACTS);
                    }
                    if (permissionNode.get(INGEST_CONTRACTS) != null) {
                        objectNode.set("IngestContracts", permissionNode.get(INGEST_CONTRACTS));
                        objectNode.remove(INGEST_CONTRACTS);
                    }
                });
            }
        });
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            mapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }
}

