/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.ArchivalProfileUnitResponseDto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class VitamArchivalProfileUnitCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamArchivalProfileUnitCommonService.class);
    private final AdminExternalClient adminExternalClient;
    private final AccessExternalClient accessExternalClient;
    private ObjectMapper objectMapper;

    @Autowired
    public VitamArchivalProfileUnitCommonService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper, AccessExternalClient accessExternalClient) {
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
        this.accessExternalClient = accessExternalClient;
    }

    public RequestResponse<ArchiveUnitProfileModel> findArchivalProfiles(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        LOGGER.info("Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findArchiveUnitProfiles(vitamContext, select);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<ArchiveUnitProfileModel> findArchivalProfileById(VitamContext vitamContext, String contractId) throws VitamClientException {
        LOGGER.info("Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findArchiveUnitProfileById(vitamContext, contractId);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<?> updateArchiveUnitProfile(VitamContext vitamContext, String id, JsonNode jsonNode) throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.info("Update Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.adminExternalClient.updateArchiveUnitProfile(vitamContext, id, jsonNode);
    }

    public RequestResponse<?> create(VitamContext vitamContext, ArchiveUnitProfileModel newArchivalProfile) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        LOGGER.info("Create Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        ArrayList<ArchiveUnitProfileModel> archiveUnitProfileModelsList = new ArrayList<ArchiveUnitProfileModel>();
        archiveUnitProfileModelsList.add(newArchivalProfile);
        return this.importArchivalProfiles(vitamContext, archiveUnitProfileModelsList);
    }

    private RequestResponse<?> importArchivalProfiles(VitamContext vitamContext, List<ArchiveUnitProfileModel> archivalProfileModels) throws InvalidParseOperationException, AccessExternalClientException, IOException, JAXBException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeArchivalProfiles(archivalProfileModels);){
            RequestResponse requestResponse = this.adminExternalClient.createArchiveUnitProfile(vitamContext, (InputStream)byteArrayInputStream);
            return requestResponse;
        }
    }

    private ByteArrayInputStream serializeArchivalProfiles(List<ArchiveUnitProfileModel> archiveUnitProfileModels) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.convertValue(archiveUnitProfileModels, JsonNode.class);
        LOGGER.debug("The json for creation profile, sent to Vitam {}", (Object)node);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            mapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public RequestResponse<?> importArchivalUnitProfileByFile(VitamContext vitamContext, String fileName, MultipartFile file) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Import archival unit profile by file {}", (Object)fileName);
        return this.adminExternalClient.createArchiveUnitProfile(vitamContext, file.getInputStream());
    }

    private void patchFields(ArchiveUnitProfileModel archivalProfileToPatch, ArchiveUnitProfileModel fieldsToApply) {
        if (fieldsToApply.getVersion() != null) {
            archivalProfileToPatch.setVersion(fieldsToApply.getVersion());
        }
    }

    public boolean checkAbilityToCreateArchivalProfileInVitam(List<ArchiveUnitProfileModel> archivalProfiles, VitamContext vitamContext) {
        if (archivalProfiles != null && !archivalProfiles.isEmpty()) {
            try {
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<ArchiveUnitProfileModel> response = this.findArchivalProfiles(vitamContext, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    throw new PreconditionFailedException("Can't create archival profile for the tenant : UNAUTHORIZED");
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    throw new UnavailableServiceException("Can't create archival profile for this tenant, Vitam response code : " + response.getStatus());
                }
                this.verifyArchivalProfileExistence(archivalProfiles, response);
            }
            catch (VitamClientException e) {
                throw new UnavailableServiceException("Can't create access contracts for this tenant, error while calling Vitam : " + e.getMessage());
            }
            return true;
        }
        throw new BadRequestException("The body is not found");
    }

    private void verifyArchivalProfileExistence(List<ArchiveUnitProfileModel> checkArchivalProfiles, RequestResponse<ArchiveUnitProfileModel> vitamArchivalProfiles) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ArchivalProfileUnitResponseDto accessContractResponseDto = (ArchivalProfileUnitResponseDto)((Object)objectMapper.treeToValue((TreeNode)vitamArchivalProfiles.toJsonNode(), ArchivalProfileUnitResponseDto.class));
            List formatsNames = checkArchivalProfiles.stream().map(ac -> ac.getName()).collect(Collectors.toList());
            if (accessContractResponseDto.getResults().stream().anyMatch(ac -> formatsNames.contains(ac.getName()))) {
                throw new ConflictException("Can't create archival profile, a format with the same name already exist in Vitam");
            }
            List formatsPuids = checkArchivalProfiles.stream().map(ac -> ac.getIdentifier()).collect(Collectors.toList());
            if (accessContractResponseDto.getResults().stream().anyMatch(ac -> formatsPuids.contains(ac.getIdentifier()))) {
                throw new ConflictException("Can't create archival profile, a format with the same puid already exist in Vitam");
            }
        }
        catch (JsonProcessingException e) {
            throw new UnexpectedDataException("Can't create access contracts, Error while parsing Vitam response : " + e.getMessage());
        }
    }
}

