/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.UnavailableServiceException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dto.ContextResponseDto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class OntologyCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyCommonService.class);
    private final AdminExternalClient adminExternalClient;

    @Autowired
    public OntologyCommonService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse<OntologyModel> findOntologyById(VitamContext vitamContext, String identifier) throws VitamClientException {
        LOGGER.info("Ontology EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse jsonResponse = this.adminExternalClient.findOntologyById(vitamContext, identifier);
        VitamRestUtils.checkResponse((RequestResponse)jsonResponse, (Integer[])new Integer[0]);
        return jsonResponse;
    }

    public RequestResponse<OntologyModel> findOntologies(VitamContext vitamContext, JsonNode jsonNode) throws VitamClientException {
        LOGGER.info("All Ontologies EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse jsonResponse = this.adminExternalClient.findOntologies(vitamContext, jsonNode);
        VitamRestUtils.checkResponse((RequestResponse)jsonResponse, (Integer[])new Integer[0]);
        return jsonResponse;
    }

    public RequestResponse<?> importOntologies(VitamContext vitamContext, List<OntologyModel> ontologies) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeOntologies(ontologies);){
            LOGGER.info("Import All Ontologies EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.adminExternalClient.importOntologies(true, vitamContext, (InputStream)byteArrayInputStream);
            return requestResponse;
        }
    }

    public RequestResponse<?> importOntologies(VitamContext vitamContext, String fileName, MultipartFile file) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Import ontology file {}", (Object)fileName);
        return this.adminExternalClient.importOntologies(false, vitamContext, file.getInputStream());
    }

    private ByteArrayInputStream serializeOntologies(List<OntologyModel> ontologiesModel) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ontologiesModel.forEach(ontology -> ontology.setId(null));
        JsonNode node = (JsonNode)mapper.convertValue(ontologiesModel, JsonNode.class);
        LOGGER.debug("The json for import ontologies, sent to Vitam {}", (Object)node);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            mapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public boolean checkAbilityToCreateOntologyInVitam(List<OntologyModel> models, VitamContext vitamContext) {
        if (models != null && !models.isEmpty()) {
            try {
                ObjectNode select = new Select().getFinalSelect();
                RequestResponse<OntologyModel> response = this.findOntologies(vitamContext, (JsonNode)select);
                if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                    throw new PreconditionFailedException("Can't create file format for the tenant : UNAUTHORIZED");
                }
                if (response.getStatus() != HttpStatus.OK.value()) {
                    throw new UnavailableServiceException("Can't create file format for this tenant, Vitam response code : " + response.getStatus());
                }
                this.verifyFileFormatExistence(models, response);
            }
            catch (VitamClientException e) {
                throw new UnavailableServiceException("Can't create access contracts for this tenant, error while calling Vitam : " + e.getMessage());
            }
            return true;
        }
        throw new BadRequestException("The body is not found");
    }

    private void verifyFileFormatExistence(List<OntologyModel> checkFileFormats, RequestResponse<OntologyModel> vitamFileFormats) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ContextResponseDto contextResponseDto = (ContextResponseDto)((Object)objectMapper.treeToValue((TreeNode)vitamFileFormats.toJsonNode(), ContextResponseDto.class));
            List contextIds = checkFileFormats.stream().map(context -> context.getIdentifier()).collect(Collectors.toList());
            if (contextResponseDto.getResults().stream().anyMatch(context -> contextIds.contains(context.getIdentifier()))) {
                throw new ConflictException("Can't create ontology, an ontology with the same identifier already exist in Vitam");
            }
        }
        catch (JsonProcessingException e) {
            throw new UnexpectedDataException("Can't create ontology, Error while parsing Vitam response : " + e.getMessage());
        }
    }
}

