/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.dsl;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitamQueryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitamQueryHelper.class);
    public static final String AGENCY_IMPORT_OPERATION_TYPE = "IMPORT_AGENCIES.OK";
    public static final String RULE_IMPORT_OPERATION_TYPE = "STP_IMPORT_RULES.OK";
    private static final String IDENTIFIER = "Identifier";
    private static final String ID = "#id";
    private static final String NAME = "Name";
    private static final String SHORT_NAME = "ShortName";
    private static final String PUID = "PUID";
    private static final String RULE_ID = "RuleId";
    private static final String RULE_VALUE = "RuleValue";
    private static final String RULE_TYPE = "RuleType";
    private static final String EV_TYPE_PROC = "evTypeProc";
    private static final String STATUS = "Status";
    private static final String EV_TYPE = "evType";
    private static final String EV_DATE_TIME_START = "evDateTime_Start";
    private static final String EV_DATE_TIME_END = "evDateTime_End";
    private static final String OPI = "Opi";
    private static final String ORIGINATING_AGENCY = "OriginatingAgency";
    private static final String SEDAVERSION = "SedaVersion";
    public static final Collection<String> staticAcquisitionInformations = List.of("Versement", "Protocole", "Achat", "Copie", "Dation", "D\u00e9p\u00f4t", "D\u00e9volution", "Don", "Legs", "R\u00e9int\u00e9gration", "Autres", "Non renseign\u00e9");
    public static final String ACQUISITION_INFORMATION_NON_RENSEIGNE = "Non renseign\u00e9";

    private VitamQueryHelper() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static JsonNode createQueryDSL(Map<String, Object> searchCriteriaMap) throws InvalidParseOperationException, InvalidCreateOperationException {
        return VitamQueryHelper.createQueryDSL(searchCriteriaMap, null, null, Optional.empty(), Optional.empty());
    }

    public static JsonNode createQueryDSL(Map<String, Object> searchCriteriaMap, Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction) throws InvalidParseOperationException, InvalidCreateOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and();
        BooleanQuery queryOr = QueryHelper.or();
        boolean isEmpty = true;
        boolean haveOrParameters = false;
        VitamQueryHelper.manageFilters(orderBy, direction, select);
        if (pageNumber != null && size != null) {
            select.setLimitFilter((long)(pageNumber * size), (long)size.intValue());
        }
        if (!searchCriteriaMap.isEmpty()) {
            isEmpty = false;
            Set<Map.Entry<String, Object>> entrySet = searchCriteriaMap.entrySet();
            block28: for (Map.Entry<String, Object> entry : entrySet) {
                String searchKey;
                switch (searchKey = entry.getKey()) {
                    case "Name": 
                    case "ShortName": 
                    case "Identifier": 
                    case "#id": 
                    case "PUID": 
                    case "SedaVersion": {
                        String stringValue = (String)entry.getValue();
                        queryOr.add(new Query[]{QueryHelper.eq((String)searchKey, (String)stringValue)});
                        haveOrParameters = true;
                        continue block28;
                    }
                    case "evTypeProc": {
                        String ruleType = (String)entry.getValue();
                        query.add(new Query[]{QueryHelper.eq((String)searchKey, (String)ruleType)});
                        continue block28;
                    }
                    case "RuleId": 
                    case "Opi": 
                    case "OriginatingAgency": {
                        String ruleId = (String)entry.getValue();
                        queryOr.add(new Query[]{QueryHelper.wildcard((String)searchKey, (String)("*" + ruleId + "*"))});
                        haveOrParameters = true;
                        continue block28;
                    }
                    case "RuleValue": {
                        String ruleValue = (String)entry.getValue();
                        queryOr.add(new Query[]{QueryHelper.matchPhrasePrefix((String)searchKey, (String)ruleValue)});
                        haveOrParameters = true;
                        continue block28;
                    }
                    case "evType": {
                        if (entry.getValue() instanceof String) {
                            String evType = (String)entry.getValue();
                            query.add(new Query[]{QueryHelper.eq((String)searchKey, (String)evType)});
                            continue block28;
                        }
                        if (!(entry.getValue() instanceof List)) continue block28;
                        ArrayList stringValues = (ArrayList)entry.getValue();
                        query.add(new Query[]{QueryHelper.in((String)searchKey, (String[])((String[])stringValues.stream().toArray(String[]::new)))});
                        continue block28;
                    }
                    case "Status": 
                    case "RuleType": {
                        ArrayList stringValues = (ArrayList)entry.getValue();
                        query.add(new Query[]{QueryHelper.in((String)searchKey, (String[])stringValues.toArray(new String[0]))});
                        continue block28;
                    }
                    case "evDateTime_Start": {
                        query.add(new Query[]{QueryHelper.gt((String)"evDateTime", (String)((String)entry.getValue()))});
                        continue block28;
                    }
                    case "evDateTime_End": {
                        query.add(new Query[]{QueryHelper.lt((String)"evDateTime", (String)((String)entry.getValue()))});
                        continue block28;
                    }
                }
                LOGGER.error("Can not find binding for key: {}", (Object)searchKey);
            }
        }
        VitamQueryHelper.setQuery(select, query, queryOr, isEmpty, haveOrParameters);
        LOGGER.debug("Final query Details: {}", (Object)select.getFinalSelect().toPrettyString());
        return select.getFinalSelect();
    }

    private static void manageFilters(Optional<String> orderBy, Optional<DirectionDto> direction, Select select) throws InvalidParseOperationException, InvalidCreateOperationException {
        if (orderBy.isPresent()) {
            String order = orderBy.get();
            if (direction.isPresent() && DirectionDto.DESC.equals((Object)direction.get())) {
                select.addOrderByDescFilter(new String[]{order});
            } else {
                select.addOrderByAscFilter(new String[]{order});
            }
        }
    }

    private static void setQuery(Select select, BooleanQuery query, BooleanQuery queryOr, boolean isEmpty, boolean haveOrParameters) throws InvalidCreateOperationException {
        if (!isEmpty) {
            if (haveOrParameters) {
                query.add(new Query[]{queryOr});
            }
            if (!query.getQueries().isEmpty()) {
                select.setQuery((Query)query);
            }
        }
    }

    public static JsonNode getLastOperationQuery(String operationType) throws InvalidCreateOperationException, InvalidParseOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and();
        query.add(new Query[]{QueryHelper.in((String)"events.outDetail", (String[])new String[]{operationType})});
        select.setQuery((Query)query);
        select.setLimitFilter(0L, 1L);
        select.addOrderByDescFilter(new String[]{"evDateTime"});
        return select.getFinalSelect();
    }

    public static JsonNode buildOperationQuery(String obId) throws InvalidCreateOperationException {
        Select select = new Select();
        CompareQuery obIdQuery = QueryHelper.eq((String)"obId", (String)obId);
        select.setQuery((Query)obIdQuery);
        return select.getFinalSelect();
    }
}

