/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.server.rest;

import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.profiles.Notice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileNotice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileType;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileVersion;
import fr.gouv.vitamui.pastis.common.dto.seda.SedaNode;
import fr.gouv.vitamui.pastis.common.exception.TechnicalException;
import fr.gouv.vitamui.pastis.common.util.NoticeUtils;
import fr.gouv.vitamui.pastis.server.service.PastisService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"pastis"})
@RequestMapping(value={"/pastis"})
@RestController
@ResponseBody
class PastisController {
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private final PastisService profileService;

    public PastisController(PastisService profileService) {
        this.profileService = profileService;
    }

    @ApiOperation(value="Download Pa Profile rng file")
    @Secured(value={"ROLE_GET_PROFILES"})
    @PostMapping(value={"/archiveprofile"}, consumes={"application/json; charset=utf-8"}, produces={"application/xml"})
    ResponseEntity<String> getArchiveProfile(@RequestParam(name="version", required=false) String profileVersion, @RequestBody ElementProperties json) throws TechnicalException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)json);
        SanityChecker.checkSecureParameter((String[])new String[]{profileVersion});
        ProfileVersion version = Objects.isNull(profileVersion) ? ProfileVersion.VERSION_2_1 : ProfileVersion.fromVersionString((String)profileVersion);
        String archiveProfile = this.profileService.getArchiveProfile(json, version);
        if (archiveProfile != null) {
            return ResponseEntity.ok((Object)archiveProfile);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Download Pua Profile json file")
    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES"})
    @PostMapping(value={"/getarchiveunitprofile"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    ResponseEntity<String> getArchiveUnitProfile(@RequestBody ProfileNotice json) throws TechnicalException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)json);
        String archiveUnitProfile = this.profileService.getArchiveUnitProfile(json, false);
        if (archiveUnitProfile != null) {
            return ResponseEntity.ok((Object)archiveUnitProfile);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Retrieve json representation from PUA notice")
    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES", "ROLE_UPDATE_PROFILES"})
    @PostMapping(value={"/edit"})
    ResponseEntity<ProfileResponse> loadProfile(@RequestBody Notice notice) throws TechnicalException, InvalidParseOperationException, PreconditionFailedException, AccessExternalNotFoundException, AccessExternalClientException {
        SanityChecker.sanitizeCriteria((Object)notice);
        if (notice.getControlSchema() == null) {
            Resource resource = (Resource)this.profileService.download(notice.getIdentifier()).getBody();
            ElementProperties elementProperties = this.profileService.loadProfilePA(resource);
            ProfileResponse profileResponse = NoticeUtils.convertToProfileResponse((Notice)notice);
            profileResponse.setProfile(elementProperties);
            return ResponseEntity.ok((Object)profileResponse);
        }
        ProfileResponse profileResponse = this.profileService.loadProfile(notice);
        if (profileResponse != null) {
            return ResponseEntity.ok((Object)profileResponse);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Retrieve json representation from input file")
    @Secured(value={"ROLE_UPDATE_ARCHIVE_PROFILES", "ROLE_CREATE_PROFILES"})
    @PostMapping(value={"/profile"}, consumes={"multipart/form-data"}, produces={"application/json"})
    ResponseEntity<ProfileResponse> loadProfileFromFile(@RequestParam MultipartFile file) throws NoSuchAlgorithmException, TechnicalException, PreconditionFailedException {
        String fileName = file.getOriginalFilename();
        SanityChecker.isValidFileName((String)fileName);
        ProfileResponse profileResponse = this.profileService.loadProfileFromFile(file, fileName, false);
        if (profileResponse != null) {
            return ResponseEntity.ok((Object)profileResponse);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Retrieve json representation from PA file")
    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES", "ROLE_UPDATE_PROFILES"})
    @PostMapping(value={"/editpa"}, consumes={"multipart/form-data"}, produces={"application/json"})
    ResponseEntity<ElementProperties> loadPA(@RequestParam(value="file") MultipartFile file) {
        ElementProperties elementProperties = this.profileService.loadProfilePA(file);
        if (elementProperties != null) {
            return ResponseEntity.ok((Object)elementProperties);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Get template profile by type")
    @Secured(value={"ROLE_UPDATE_ARCHIVE_PROFILES", "ROLE_CREATE_PROFILES"})
    @GetMapping(value={"/profile"})
    ResponseEntity<ProfileResponse> createProfile(@RequestParam(name="type") String profileType, @RequestParam(name="version", required=false) String profileVersion) throws NoSuchAlgorithmException, TechnicalException, InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{profileType});
        SanityChecker.checkSecureParameter((String[])new String[]{profileVersion});
        ProfileType type = Objects.isNull(profileType) ? null : ProfileType.valueOf((String)profileType);
        ProfileVersion version = Objects.isNull(profileVersion) ? ProfileVersion.VERSION_2_1 : ProfileVersion.fromVersionString((String)profileVersion);
        ProfileResponse profileResponse = this.profileService.createProfile(type, version, false);
        if (profileResponse != null) {
            return ResponseEntity.ok((Object)profileResponse);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ApiOperation(value="Get meta-model by type and version")
    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES", "ROLE_GET_PROFILES"})
    @GetMapping(value={"/metamodel"})
    ResponseEntity<SedaNode> getMetaModel(@RequestParam(name="version") String version) throws IOException {
        SanityChecker.checkSecureParameter((String[])new String[]{version});
        ProfileVersion profileVersion = ProfileVersion.fromVersionString((String)version);
        SedaNode sedaNode = this.profileService.getMetaModel(profileVersion);
        if (sedaNode == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)sedaNode);
    }
}

