/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.server.service.converters.TransactionConverter;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.RequestTimeOutException;
import fr.gouv.vitamui.commons.api.utils.MetadataSearchCriteriaUtils;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import java.io.InputStream;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransactionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionService.class);
    public static final String UNABLE_TO_UPDATE_TRANSACTION = "Unable to update transaction";
    public static final String UNABLE_TO_PROCESS_RESPONSE = "Unable to process response";
    public static final String UNABLE_TO_PROCESS_UNIT_UPDATE = "Unable to process units update operation";
    public static final String ERROR_400 = "ERROR_400";
    public static final String REQUEST_TIMEOUT_EXCEPTION_MESSAGE = "the server has decided to close the connection rather than continue waiting";
    public static final String DSL_QUERY_PROJECTION = "$projection";
    public static final String DSL_QUERY_FILTER = "$filter";
    public static final String DSL_QUERY_THRESHOLD = "$threshold";
    public static final String DSL_QUERY_FACETS = "$facets";
    public static final String OPERATION_IDENTIFIER = "itemId";
    private static final String ACTION = "$action";
    private final CollectService collectService;

    public void validateTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.validateTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when validating transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to validate transaction : ", (Throwable)e);
        }
    }

    public void sendTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.sendTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when sending transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to send transaction : ", (Throwable)e);
        }
    }

    public void abortTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.abortTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when aborting transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to abort transaction : ", (Throwable)e);
        }
    }

    public void reopenTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.reopenTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when reopening transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to reopen transaction : ", (Throwable)e);
        }
    }

    public CollectTransactionDto getTransactionById(String transactionId, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.getTransactionById(vitamContext, transactionId);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when getting transaction!");
            }
            return TransactionConverter.toVitamUiDto((TransactionDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), TransactionDto.class));
        }
        catch (InvalidParseOperationException | VitamClientException e) {
            throw new VitamClientException("Unable to find transaction : ", e);
        }
    }

    public CollectTransactionDto updateTransaction(CollectTransactionDto collectTransactionDto, VitamContext vitamContext) {
        LOGGER.debug("CollectTransactionDto: ", (Object)collectTransactionDto);
        try {
            TransactionDto transactionDto = TransactionConverter.toVitamDto(collectTransactionDto);
            RequestResponse requestResponse = this.collectService.updateTransaction(vitamContext, transactionDto);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when updating transaction!");
            }
            TransactionDto responseTransactionDto = (TransactionDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), TransactionDto.class);
            return TransactionConverter.toVitamUiDto(responseTransactionDto);
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to update transaction: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_UPDATE_TRANSACTION, (Throwable)e);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.debug("Unable to process response: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_PROCESS_RESPONSE, (Throwable)e);
        }
    }

    public String updateArchiveUnitsFromFile(InputStream inputStream, String transactionId, VitamContext vitamContext) throws RequestTimeOutException {
        LOGGER.debug("[Internal] call update Archive Units From File for transaction Id {}  ", (Object)transactionId);
        String result = this.collectService.updateCollectArchiveUnits(vitamContext, transactionId, inputStream);
        if (result.equals(ERROR_400)) {
            LOGGER.debug(UNABLE_TO_PROCESS_UNIT_UPDATE);
            throw new RequestTimeOutException(REQUEST_TIMEOUT_EXCEPTION_MESSAGE, REQUEST_TIMEOUT_EXCEPTION_MESSAGE);
        }
        return result;
    }

    public String reclassification(String transactionId, ReclassificationCriteriaDto reclassificationCriteriaDto, VitamContext vitamContext) throws VitamClientException {
        if (reclassificationCriteriaDto == null) {
            throw new BadRequestException("Error reclassification criteria");
        }
        LOGGER.debug("Reclassification Object : {}", (Object)reclassificationCriteriaDto.toString());
        JsonNode dslQuery = MetadataSearchCriteriaUtils.mapRequestToDslQuery((SearchCriteriaDto)reclassificationCriteriaDto.getSearchCriteriaDto());
        ArrayNode array = JsonHandler.createArrayNode();
        ((ObjectNode)dslQuery).putPOJO(ACTION, (Object)reclassificationCriteriaDto.getAction());
        Arrays.stream(new String[]{DSL_QUERY_PROJECTION, DSL_QUERY_FILTER, DSL_QUERY_FACETS, DSL_QUERY_THRESHOLD}).forEach(arg_0 -> ((ObjectNode)((ObjectNode)dslQuery)).remove(arg_0));
        array.add(dslQuery);
        LOGGER.debug("Reclassification query : {}", (Object)array);
        RequestResponse jsonNodeRequestResponse = this.collectService.reclassification(vitamContext, transactionId, (JsonNode)array);
        return jsonNodeRequestResponse.toJsonNode().findValue(OPERATION_IDENTIFIER).textValue();
    }

    @Generated
    public TransactionService(CollectService collectService) {
        this.collectService = collectService;
    }
}

