/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.service;

import fr.gouv.vitamui.collect.server.dao.SearchCriteriaHistoryRepository;
import fr.gouv.vitamui.collect.server.domain.SearchCriteriaHistoryCollect;
import fr.gouv.vitamui.collect.server.service.converters.SearchCriteriaHistoryConverter;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SearchCriteriaHistoryService
extends VitamUICrudService<SearchCriteriaHistoryDto, SearchCriteriaHistoryCollect> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchCriteriaHistoryService.class);
    private static final String MAX_SEARCH_CRITERIA_SAVED_ACHIEVED = "L\u2019enregistrement n'est pas possible car vous avez atteint le nombre limite de recherches enregistr\u00e9es. Veuillez supprimer au moins une de vos recherches.";
    private final SearchCriteriaHistoryRepository searchCriteriaHistoryRepo;
    private final SearchCriteriaHistoryConverter searchCriteriaHistoryConverter;
    private final SecurityService securityService;

    public SearchCriteriaHistoryService(SequenceGeneratorService sequenceGeneratorService, SearchCriteriaHistoryRepository searchCriteriaHistoryRepo, SearchCriteriaHistoryConverter searchCriteriaHistoryConverter, SecurityService securityService) {
        super(sequenceGeneratorService);
        this.searchCriteriaHistoryRepo = searchCriteriaHistoryRepo;
        this.searchCriteriaHistoryConverter = searchCriteriaHistoryConverter;
        this.securityService = securityService;
    }

    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistoryDtos() {
        LOGGER.debug("getSearchCriteriaHistoryDtos");
        AuthUserDto authUserDto = this.securityService.getUser();
        LOGGER.debug("Get the search history for user : {}", (Object)authUserDto.getIdentifier());
        QueryDto criteria = new QueryDto();
        criteria.addCriterion(new Criterion("userId", (Object)authUserDto.getIdentifier(), CriterionOperator.EQUALS));
        return this.getAll(criteria);
    }

    protected void beforeCreate(SearchCriteriaHistoryDto dto) {
        AuthUserDto authUserDto = this.securityService.getUser();
        dto.setUserId(authUserDto.getIdentifier());
        List<SearchCriteriaHistoryDto> list = this.getSearchCriteriaHistoryDtos();
        if (null != list && list.size() >= 10) {
            LOGGER.warn(MAX_SEARCH_CRITERIA_SAVED_ACHIEVED);
            throw new IllegalArgumentException(MAX_SEARCH_CRITERIA_SAVED_ACHIEVED);
        }
    }

    protected SearchCriteriaHistoryRepository getRepository() {
        return this.searchCriteriaHistoryRepo;
    }

    protected Class<SearchCriteriaHistoryCollect> getEntityClass() {
        return SearchCriteriaHistoryCollect.class;
    }

    protected String getObjectName() {
        return "searchCriteriaHistory";
    }

    protected Converter<SearchCriteriaHistoryDto, SearchCriteriaHistoryCollect> getConverter() {
        return this.searchCriteriaHistoryConverter;
    }
}

