/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.iam.client.ExternalParametersRestClient;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ExternalParametersService {
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    private final ExternalParametersRestClient externalParametersRestClient;
    private final SecurityService securityService;
    private final AccessContractCommonService accessContractCommonService;

    @Nonnull
    private String retrieveAccessContractFromExternalParam() {
        Map myExternalParameter = this.externalParametersRestClient.getMyExternalParameters(this.securityService.getHttpContext());
        if (myExternalParameter == null || CollectionUtils.isEmpty(myExternalParameter.entrySet())) {
            throw new IllegalArgumentException("No external profile defined for access contract defined");
        }
        Map.Entry parameterAccessContract = myExternalParameter.entrySet().stream().filter(entry -> PARAM_ACCESS_CONTRACT_NAME.equals(entry.getKey())).findFirst().orElse(null);
        if (Objects.isNull(parameterAccessContract) || Objects.isNull(parameterAccessContract.getValue())) {
            throw new IllegalArgumentException("No access contract defined");
        }
        return (String)parameterAccessContract.getValue();
    }

    @Nullable
    public AccessContractModel retrieveAccessContract() throws VitamClientException, JsonProcessingException {
        RequestResponse response = this.accessContractCommonService.findAccessContractById(this.buildVitamContextFromExternalParam(), this.retrieveAccessContractFromExternalParam());
        return response != null && response.isOk() && CollectionUtils.isNotEmpty((Collection)((RequestResponseOK)response).getResults()) ? (AccessContractModel)((RequestResponseOK)response).getResults().get(0) : null;
    }

    public VitamContext buildVitamContextFromExternalParam() {
        return new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
    }

    @Generated
    public ExternalParametersService(ExternalParametersRestClient externalParametersRestClient, SecurityService securityService, AccessContractCommonService accessContractCommonService) {
        this.externalParametersRestClient = externalParametersRestClient;
        this.securityService = securityService;
        this.accessContractCommonService = accessContractCommonService;
    }
}

